/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jboss.dashboard.database.DataSourceEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalDataSource
implements DataSource {
    protected static transient Logger log = LoggerFactory.getLogger((String)ExternalDataSource.class.getName());
    protected String name = null;
    protected DataSourceEntry dataSourceEntry = null;
    private PrintWriter printWriter = new PrintWriter(System.out);
    private int loginTimeOut = 0;
    private boolean disableAutoCommit = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataSourceEntry(DataSourceEntry dataSourceEntry) {
        this.dataSourceEntry = dataSourceEntry;
    }

    public DataSourceEntry getDataSourceEntry() {
        return this.dataSourceEntry;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeOut;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeOut = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    public boolean isDisableAutoCommit() {
        return this.disableAutoCommit;
    }

    public void setDisableAutoCommit(boolean disableAutoCommit) {
        this.disableAutoCommit = disableAutoCommit;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            log.debug("Obtain data source connection: " + this.name);
            Connection conn = this.dataSourceEntry.getConnection();
            this.setAutoCommit(conn, !this.disableAutoCommit);
            return conn;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return null;
    }

    protected boolean getAutoCommit(Connection conn) {
        try {
            return conn.getAutoCommit();
        }
        catch (SQLException e) {
            log.debug("Can not get autocommit for datasource: " + this.name, (Throwable)e);
            return true;
        }
    }

    protected void setAutoCommit(Connection conn, boolean autocommit) {
        try {
            if (this.getAutoCommit(conn) != autocommit) {
                conn.setAutoCommit(autocommit);
            }
        }
        catch (SQLException e) {
            log.debug("Can not set autocommit for datasource: " + this.name, (Throwable)e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> c) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> c) {
        return null;
    }
}

