/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.error;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.error.ApplicationError;
import org.jboss.dashboard.error.BusinessError;
import org.jboss.dashboard.error.ErrorReport;
import org.jboss.dashboard.error.ErrorTrace;
import org.jboss.dashboard.error.TechnicalError;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.ThreadProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ErrorManager {
    private static transient Logger log = LoggerFactory.getLogger((String)ErrorManager.class.getName());
    @Inject
    @Config(value="true")
    protected boolean logErrorReportEnabled;
    @Inject
    @Config(value="true")
    protected boolean logDBInterlockThreadsEnabled;

    public static ErrorManager lookup() {
        return CoreServices.lookup().getErrorManager();
    }

    public boolean isLogErrorReportEnabled() {
        return this.logErrorReportEnabled;
    }

    public void setLogErrorReportEnabled(boolean logErrorReportEnabled) {
        this.logErrorReportEnabled = logErrorReportEnabled;
    }

    public boolean isLogDBInterlockThreadsEnabled() {
        return this.logDBInterlockThreadsEnabled;
    }

    public void setLogDBInterlockThreadsEnabled(boolean logDBInterlockThreadsEnabled) {
        this.logDBInterlockThreadsEnabled = logDBInterlockThreadsEnabled;
    }

    public void throwTechnicalError(String message, Throwable cause) {
        throw new TechnicalError(message, cause);
    }

    public void throwBusinessError(String title, String message) {
        throw new BusinessError(0, title, message);
    }

    public void throwBusinessWarning(String title, String message) {
        throw new BusinessError(1, title, message);
    }

    public void throwBusinessInfo(String title, String message) {
        throw new BusinessError(2, title, message);
    }

    public ApplicationError getApplicationErrorCause(Throwable e) {
        LinkedList<ApplicationError> appErrors = new LinkedList<ApplicationError>();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ApplicationError)) continue;
            appErrors.add((ApplicationError)cause);
        }
        if (appErrors.isEmpty()) {
            return null;
        }
        return (ApplicationError)appErrors.getLast();
    }

    public Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable root = t.getCause();
        if (root == null) {
            if (t instanceof ServletException) {
                root = ((ServletException)t).getRootCause();
            }
            if (t instanceof JspException) {
                root = ((JspException)t).getRootCause();
            }
            if (t instanceof InvocationTargetException) {
                root = ((InvocationTargetException)t).getTargetException();
            }
        }
        if (root == null) {
            return t;
        }
        return this.getRootCause(root);
    }

    public boolean isDBInterlockException(Throwable e) {
        Throwable root = e;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        if (root.getClass().getName().endsWith("SQLServerException") && root.getMessage().indexOf("en bloqueo recursos con otro proceso y fue elegida como sujeto del interbloqueo") != -1) {
            return true;
        }
        if (root.getClass().getName().endsWith("PSQLException") && root.getMessage().indexOf("ERROR: no se pudo serializar el acceso debido a un update concurrente") != -1) {
            return true;
        }
        return root.getClass().getName().endsWith("SQLException") && root.getMessage().indexOf("ORA-00060: detectado interbloqueo mientras se esperaba un recurso") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorReport notifyError(Throwable t, boolean doLog) {
        ThreadProfile threadProfile = Profiler.lookup().getCurrentThreadProfile();
        if (threadProfile.getErrorReport() != null) {
            return threadProfile.getErrorReport();
        }
        ErrorReport report = new ErrorReport();
        report.setId(String.valueOf(System.currentTimeMillis()));
        report.setException(t);
        CodeBlockTrace trace = new ErrorTrace(report).begin();
        try {
            threadProfile.setErrorReport(report);
            if (doLog) {
                this.logError(report);
            }
        }
        finally {
            trace.end();
        }
        return report;
    }

    public void logError(ErrorReport report) {
        ApplicationError appError = this.getApplicationErrorCause(report.getException());
        if (appError == null) {
            if (this.logErrorReportEnabled) {
                log.error("UNEXPECTED ERROR.\n" + report.printContext(0));
            }
            if (this.logDBInterlockThreadsEnabled && this.isDBInterlockException(this.getRootCause(report.getException()))) {
                log.error(Profiler.lookup().printActiveThreadsReport());
            }
        }
    }
}

