/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.misc;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.commons.text.StringUtil;

public class ReflectionUtils {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_IS = "is";
    public static final String ARRAYS_DELIMITER = ",";

    public static Object getPrivateField(Object o, String fieldName) {
        Field[] fields = o.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            try {
                fields[i].setAccessible(true);
                return fields[i].get(o);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object o, String methodName, Object[] params) {
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            try {
                methods[i].setAccessible(true);
                return methods[i].invoke(o, params);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (InvocationTargetException ite) {
                return null;
            }
        }
        return null;
    }

    public static List<Field> getClassHierarchyFields(Class clazz, Class fieldType, boolean isStatic, String[] fieldsToIgnore) {
        ArrayList<Field> results = new ArrayList<Field>();
        if (clazz == null) {
            return results;
        }
        if (clazz.equals(Object.class)) {
            return results;
        }
        List<Field> superClassFields = ReflectionUtils.getClassHierarchyFields(clazz.getSuperclass(), fieldType, isStatic, fieldsToIgnore);
        results.addAll(superClassFields);
        List<Field> classFields = ReflectionUtils.getClassFields(clazz, fieldType, isStatic, fieldsToIgnore);
        results.addAll(classFields);
        return results;
    }

    public static List<Field> getClassFields(Class clazz, Class type, boolean isStatic, String[] fieldsToIgnore) {
        ArrayList<Field> results = new ArrayList<Field>();
        if (clazz == null) {
            return results;
        }
        if (clazz.isPrimitive()) {
            return results;
        }
        if (clazz.isAnnotation()) {
            return results;
        }
        if (clazz.isInterface()) {
            return results;
        }
        if (clazz.isEnum()) {
            return results;
        }
        Collection<Object> toIgnore = fieldsToIgnore != null ? Arrays.asList(fieldsToIgnore) : Collections.EMPTY_SET;
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (toIgnore.contains(field.getName()) || isStatic && !Modifier.isStatic(field.getModifiers()) || !isStatic && Modifier.isStatic(field.getModifiers()) || type != null && !field.getType().equals(type)) continue;
            results.add(field);
        }
        return results;
    }

    public static Class[] getClassHierarchyInterfaces(Class clazz) {
        int i;
        if (clazz == null) {
            return new Class[0];
        }
        if (clazz.equals(Object.class)) {
            return new Class[0];
        }
        ArrayList results = new ArrayList();
        Class<?>[] ifaces = clazz.getInterfaces();
        for (i = 0; i < ifaces.length; ++i) {
            if (results.contains(ifaces[i])) continue;
            results.add(ifaces[i]);
        }
        ifaces = ReflectionUtils.getClassHierarchyInterfaces(clazz.getSuperclass());
        for (i = 0; i < ifaces.length; ++i) {
            if (results.contains(ifaces[i])) continue;
            results.add(ifaces[i]);
        }
        int index = 0;
        Class[] array = new Class[results.size()];
        for (Class clazz2 : results) {
            array[index++] = clazz2;
        }
        return array;
    }

    public static final String getGetMethodName(String fieldName) {
        return PREFIX_GET + ReflectionUtils.getValidAccessorName(fieldName);
    }

    public static final String getSetMethodName(String fieldName) {
        return PREFIX_SET + ReflectionUtils.getValidAccessorName(fieldName);
    }

    private static String getValidAccessorName(String fieldName) {
        char firstChar = fieldName.charAt(0);
        String field = StringUtil.toJavaClassName(fieldName);
        if (fieldName.length() > 1) {
            char secondChar = fieldName.charAt(1);
            if (Character.isLowerCase(firstChar) && Character.isUpperCase(secondChar)) {
                field = field.replaceFirst(Character.toString(field.charAt(0)), Character.toString(firstChar));
            }
        }
        return field;
    }

    public static final boolean isSetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith(PREFIX_SET)) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class;
    }

    public static final boolean isGetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith(PREFIX_GET)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != null;
    }

    public static final boolean isIsMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith(PREFIX_IS)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.getReturnType().isPrimitive() && method.getReturnType() != Boolean.TYPE) {
            return false;
        }
        return method.getReturnType().isPrimitive() || method.getReturnType() == Boolean.class;
    }

    public static Object parseAndSetFieldValues(Object obj, String fieldName, String[] fieldValues) throws Exception {
        StringBuffer propertyValue = new StringBuffer();
        for (int i = 0; i < fieldValues.length; ++i) {
            String value = fieldValues[i];
            if (i != 0) {
                propertyValue.append(ARRAYS_DELIMITER);
            }
            if (fieldValues.length > 1) {
                propertyValue.append(StringUtils.replace((String)value, (String)ARRAYS_DELIMITER, (String)",,"));
                continue;
            }
            propertyValue.append(value);
        }
        return ReflectionUtils.parseAndSetFieldValue(obj, fieldName, propertyValue.toString());
    }

    public static Object parseAndSetFieldValue(Object obj, String fieldName, String fieldValue) throws Exception {
        if (obj instanceof Map) {
            ((Map)obj).put(fieldName, ReflectionUtils.parseValue(fieldValue, String.class));
        } else if (obj instanceof List) {
            int index = Integer.parseInt(fieldName);
            while (((List)obj).size() <= index) {
                ((List)obj).add(null);
            }
            ((List)obj).set(index, ReflectionUtils.parseValue(fieldValue, String.class));
        } else if (fieldName.indexOf(46) != -1) {
            JXPathContext ctx = JXPathContext.newContext((Object)obj);
            ctx.setValue(fieldName.replace('.', '/'), (Object)ReflectionUtils.parseValue(fieldValue, String.class));
        } else {
            Field field = ReflectionUtils.getField(obj, fieldName);
            if (field != null) {
                Class<?> fieldClass = field.getType();
                Object value = ReflectionUtils.parseValue(fieldValue, fieldClass);
                field.set(obj, value);
                return obj;
            }
            Method getter = ReflectionUtils.getGetter(obj, fieldName);
            Method setter = ReflectionUtils.getSetter(obj, getter, fieldName);
            if (setter != null && getter != null) {
                Object value = ReflectionUtils.parseValue(fieldValue, getter.getReturnType());
                setter.invoke(obj, value);
            }
        }
        return obj;
    }

    public static Object setFieldValue(Object obj, String fieldName, Object fieldValue) throws Exception {
        if (obj instanceof Map) {
            ((Map)obj).put(fieldName, fieldValue);
        } else if (obj instanceof List) {
            int index = Integer.parseInt(fieldName);
            while (((List)obj).size() <= index) {
                ((List)obj).add(null);
            }
            ((List)obj).set(index, fieldValue);
        } else if (fieldName.indexOf(46) != -1) {
            JXPathContext ctx = JXPathContext.newContext((Object)obj);
            ctx.setValue(fieldName.replace('.', '/'), fieldValue);
        } else {
            Field field = ReflectionUtils.getField(obj, fieldName);
            if (field != null) {
                field.set(obj, fieldValue);
                return obj;
            }
            Method getter = ReflectionUtils.getGetter(obj, fieldName);
            Method setter = ReflectionUtils.getSetter(obj, getter, fieldName);
            if (setter != null && getter != null) {
                setter.invoke(obj, fieldValue);
            }
        }
        return obj;
    }

    public static Object setFieldFile(Object obj, String fieldName, File fieldValue) throws Exception {
        Method getter;
        Method setter;
        Field field = ReflectionUtils.getField(obj, fieldName);
        if (field != null) {
            Class<?> fieldClass = field.getType();
            if (File.class.equals(fieldClass)) {
                field.set(obj, fieldValue);
            } else if (byte[].class.equals(fieldClass)) {
                field.set(obj, ReflectionUtils.toByteArray(fieldValue));
            } else {
                throw new IllegalArgumentException("Field specified is not a File/byte[]: " + fieldName);
            }
        }
        if ((setter = ReflectionUtils.getSetter(obj, getter = ReflectionUtils.getGetter(obj, fieldName), fieldName)) != null && getter != null) {
            Class<?> returnType = getter.getReturnType();
            if (File.class.equals(returnType)) {
                setter.invoke(obj, fieldValue);
            } else if (byte[].class.equals(returnType)) {
                setter.invoke(obj, new Object[]{ReflectionUtils.toByteArray(fieldValue)});
            } else {
                throw new IllegalArgumentException("Field specified is not a File/byte[]: " + fieldName);
            }
        }
        return obj;
    }

    public static Field getField(Object obj, String propertyName) {
        try {
            Field field = obj.getClass().getField(propertyName);
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isFinal(field.getModifiers())) {
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static Method getGetter(Object obj, String propertyName) {
        Method getter = null;
        String propertyAccessorSuffix = StringUtils.capitalize((String)propertyName);
        String getterName = PREFIX_GET + propertyAccessorSuffix;
        try {
            getter = obj.getClass().getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String booleanGetterName = PREFIX_IS + propertyAccessorSuffix;
            try {
                getter = obj.getClass().getMethod(booleanGetterName, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        return getter;
    }

    public static Method getSetter(Object obj, Method getter, String propertyName) {
        Method setter = null;
        String propertyAccessorSuffix = StringUtils.capitalize((String)propertyName);
        String setterName = PREFIX_SET + propertyAccessorSuffix;
        Class<?> returnType = getter.getReturnType();
        try {
            setter = obj.getClass().getMethod(setterName, returnType);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return setter;
    }

    public static <T> T newInstanceForClass(Class<T> type) {
        Object object = null;
        if (type.isArray()) {
            Class<?> componentClass = type.getComponentType();
            if (componentClass.isPrimitive()) {
                if (componentClass.equals(Integer.TYPE)) {
                    object = new int[0];
                } else if (componentClass.equals(Boolean.TYPE)) {
                    object = new boolean[0];
                } else if (componentClass.equals(Long.TYPE)) {
                    object = new long[0];
                } else if (componentClass.equals(Character.TYPE)) {
                    object = new char[0];
                } else if (componentClass.equals(Double.TYPE)) {
                    object = new double[0];
                } else if (componentClass.equals(Float.TYPE)) {
                    object = new float[0];
                } else if (componentClass.equals(Byte.TYPE)) {
                    object = new byte[0];
                } else if (componentClass.equals(Short.TYPE)) {
                    object = new short[0];
                }
            } else {
                object = String.class.equals(componentClass) ? new String[]{} : (componentClass.equals(Integer.class) ? new Integer[]{} : (componentClass.equals(Boolean.class) ? new Boolean[]{} : (componentClass.equals(Long.class) ? new Long[]{} : (componentClass.equals(Character.class) ? new Character[]{} : (componentClass.equals(Double.class) ? new Double[]{} : (componentClass.equals(Float.class) ? new Float[]{} : (componentClass.equals(Byte.class) ? new Byte[]{} : (componentClass.equals(Short.class) ? new Short[]{} : Array.newInstance(componentClass, 0)))))))));
            }
        } else {
            object = String.class.equals(type) ? "" : (type.equals(Integer.TYPE) ? new Integer(0) : (type.equals(Boolean.TYPE) ? Boolean.FALSE : (type.equals(Long.TYPE) ? new Long(0L) : (type.equals(Character.TYPE) ? new Character('\u0000') : (type.equals(Double.TYPE) ? new Double(0.0) : (type.equals(Float.TYPE) ? new Float(0.0f) : (type.equals(Byte.TYPE) ? new Byte(0) : (type.equals(Short.TYPE) ? new Short(0) : (type.equals(Integer.class) ? new Integer(0) : (type.equals(Boolean.class) ? Boolean.FALSE : (type.equals(Long.class) ? new Long(0L) : (type.equals(Character.class) ? (Serializable)new Character('\u0000') : (Serializable)(type.equals(Double.class) ? (Number)new Double(0.0) : (Number)(type.equals(Float.class) ? (Number)new Float(0.0f) : (Number)(type.equals(Byte.class) ? (Number)new Byte(0) : (Number)(type.equals(Short.class) ? new Short(0) : null))))))))))))))));
        }
        return type.cast(object);
    }

    public static <T> T parseValue(String value, Class<T> type) throws Exception {
        if (type.isArray()) {
            return type.cast(ReflectionUtils.toArray(value, type.getComponentType()));
        }
        Object object = null;
        if (String.class.equals(type)) {
            object = value;
        } else if (type.equals(Integer.TYPE)) {
            object = ReflectionUtils.toInt(value);
        } else if (type.equals(Boolean.TYPE)) {
            object = ReflectionUtils.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
        } else if (type.equals(Long.TYPE)) {
            object = ReflectionUtils.toLong(value);
        } else if (type.equals(Character.TYPE)) {
            object = Character.valueOf(ReflectionUtils.toChar(value));
        } else if (type.equals(Double.TYPE)) {
            object = ReflectionUtils.toDouble(value);
        } else if (type.equals(Float.TYPE)) {
            object = Float.valueOf(ReflectionUtils.toFloat(value));
        } else if (type.equals(Byte.TYPE)) {
            object = ReflectionUtils.toByte(value);
        } else if (type.equals(Short.TYPE)) {
            object = ReflectionUtils.toShort(value);
        } else if (type.equals(File.class)) {
            object = ReflectionUtils.toFile(value);
        } else if (type.equals(Integer.class)) {
            object = ReflectionUtils.toInt(value);
        } else if (type.equals(Boolean.class)) {
            object = ReflectionUtils.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
        } else if (type.equals(Long.class)) {
            object = ReflectionUtils.toLong(value);
        } else if (type.equals(Character.class)) {
            object = Character.valueOf(ReflectionUtils.toChar(value));
        } else if (type.equals(Double.class)) {
            object = ReflectionUtils.toDouble(value);
        } else if (type.equals(Float.class)) {
            object = Float.valueOf(ReflectionUtils.toFloat(value));
        } else if (type.equals(Byte.class)) {
            object = ReflectionUtils.toByte(value);
        } else if (type.equals(Short.class)) {
            object = ReflectionUtils.toShort(value);
        }
        return (T)object;
    }

    public static Object[] toArray(String value, Class type) throws Exception {
        if (type.isArray()) {
            throw new Exception("Nested array is not supported.");
        }
        ArrayList<String> objectValue = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(value, ARRAYS_DELIMITER, true);
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            int delimiterCount = 0;
            boolean addTrailingToken = true;
            while (ARRAYS_DELIMITER.equals(token)) {
                addTrailingToken = false;
                if (++delimiterCount % 2 == 0) {
                    String lastToken = (String)objectValue.get(objectValue.size() - 1);
                    objectValue.set(objectValue.size() - 1, lastToken + ARRAYS_DELIMITER);
                    if (stk.hasMoreTokens()) {
                        token = stk.nextToken();
                        if (ARRAYS_DELIMITER.equals(token)) continue;
                        lastToken = (String)objectValue.get(objectValue.size() - 1);
                        objectValue.remove(objectValue.size() - 1);
                        objectValue.add(lastToken + token);
                        continue;
                    }
                    addTrailingToken = false;
                    break;
                }
                if (delimiterCount % 2 == 1 && !stk.hasMoreTokens()) {
                    objectValue.add("");
                    continue;
                }
                if (!stk.hasMoreTokens()) continue;
                token = stk.nextToken();
                addTrailingToken = true;
            }
            if (!addTrailingToken) continue;
            objectValue.add(token);
        }
        for (int i = 0; i < objectValue.size(); ++i) {
            String s = (String)objectValue.get(i);
            objectValue.set(i, (String)ReflectionUtils.parseValue(s, type));
        }
        Object baseObjectArray = ReflectionUtils.getBaseArray(type, objectValue.size());
        return objectValue.toArray((Object[])baseObjectArray);
    }

    private static Object getBaseArray(Class type, int length) {
        if (type.isPrimitive()) {
            if (type.equals(Integer.TYPE)) {
                return new Integer[length];
            }
            if (type.equals(Boolean.TYPE)) {
                return new Boolean[length];
            }
            if (type.equals(Long.TYPE)) {
                return new Long[length];
            }
            if (type.equals(Character.TYPE)) {
                return new Character[length];
            }
            if (type.equals(Double.TYPE)) {
                return new Double[length];
            }
            if (type.equals(Float.TYPE)) {
                return new Float[length];
            }
            if (type.equals(Byte.TYPE)) {
                return new Byte[length];
            }
            if (type.equals(Short.TYPE)) {
                return new Short[length];
            }
        }
        return Array.newInstance(type, length);
    }

    public static int toInt(String parameter) throws Exception {
        return Integer.parseInt(parameter);
    }

    public static boolean toBoolean(String parameter) throws Exception {
        return Boolean.valueOf(parameter);
    }

    public static long toLong(String parameter) throws Exception {
        return Long.parseLong(parameter);
    }

    public static char toChar(String parameter) throws Exception {
        if (parameter.length() != 1) {
            throw new Exception("Invalid value for a char " + parameter);
        }
        return parameter.charAt(0);
    }

    public static double toDouble(String parameter) throws Exception {
        return Double.parseDouble(parameter);
    }

    public static float toFloat(String parameter) throws Exception {
        return Float.parseFloat(parameter);
    }

    public static byte toByte(String parameter) throws Exception {
        return Byte.parseByte(parameter);
    }

    public static short toShort(String parameter) throws Exception {
        return Short.parseShort(parameter);
    }

    public static Object toFile(String paramValue) {
        if (paramValue == null || "".equals(paramValue.trim())) {
            return null;
        }
        if (paramValue.startsWith("/") || paramValue.contains(":")) {
            return new File(paramValue);
        }
        return new File(Application.lookup().getBaseAppDirectory() + "/" + paramValue);
    }

    public static byte[] toByteArray(File f) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        int byteRead = -1;
        while ((byteRead = bis.read()) != -1) {
            bos.write(byteRead);
        }
        bis.close();
        bos.close();
        return bos.toByteArray();
    }

    public static void main(String[] args) {
        String s = "pepe";
        Object v1 = ReflectionUtils.getPrivateField(s, "cunt");
        Object v2 = ReflectionUtils.invokeMethod(s, "sustring", new Object[]{new Integer(1)});
        System.out.println(v1);
        System.out.println(v2);
    }
}

