/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.text;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatUtil {
    private static final SimpleDateFormat shortdf = new SimpleDateFormat("dd/MM/yyyy");
    private static final SimpleDateFormat longdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private static final SimpleDateFormat nativedf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
    private static final SimpleDateFormat hourdf = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat utcdf = new SimpleDateFormat("yyyyMMddHHmmss'Z'");

    private DateFormatUtil() {
    }

    public static boolean isLongDate(Timestamp date) {
        return date.toString().indexOf("00:00:00") == -1;
    }

    public static boolean isValidDate(String text) throws ParseException {
        if (text == null || text.trim().equals("")) {
            return true;
        }
        Timestamp date = DateFormatUtil.strToTimestamp(text = text.trim());
        if (date == null) {
            return false;
        }
        if (DateFormatUtil.isLongDate(date)) {
            return longdf.format(date).equals(text);
        }
        return shortdf.format(date).equals(text);
    }

    public static String timeToStr(Date date) {
        if (date == null) {
            date = new Date();
        }
        return hourdf.format(date);
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            date = new Date();
        }
        return shortdf.format(date);
    }

    public static Timestamp strToTimestamp(String text) throws ParseException {
        text = text.trim();
        return new Timestamp(shortdf.parse(text).getTime());
    }

    public static Timestamp nativeStrToTimestamp(String text) throws ParseException {
        text = text.trim();
        return new Timestamp(nativedf.parse(text).getTime());
    }

    public static String dateToUTCStr(Date UTCDate) throws ParseException {
        if (UTCDate == null) {
            return "";
        }
        return utcdf.format(UTCDate);
    }

    public static Date utcStrToDate(String UTCTime) throws ParseException {
        if (UTCTime == null) {
            return new Date();
        }
        return utcdf.parse(UTCTime);
    }

    public static String dateToOracleStr(Timestamp ts) {
        StringBuffer tsString = new StringBuffer("null");
        if (ts != null) {
            tsString.append("to_date('").append(ts.toString().substring(0, 19)).append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return tsString.toString();
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        utcdf.setTimeZone(tz);
    }
}

