/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Cache;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.annotation.Priority;
import org.jboss.dashboard.annotation.Startable;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.database.DataSourceManager;
import org.jboss.dashboard.database.DatabaseAutoSynchronizer;
import org.jboss.dashboard.database.JNDIDataSourceEntry;
import org.jboss.dashboard.database.hibernate.HibernateSessionFactoryProvider;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HibernateInitializer
implements Startable {
    private static transient Logger log = LoggerFactory.getLogger((String)HibernateInitializer.class.getName());
    public static final String DB_H2 = "h2";
    public static final String DB_POSTGRES = "postgres";
    public static final String DB_MYSQL = "mysql";
    public static final String DB_ORACLE = "oracle";
    public static final String DB_SQLSERVER = "sqlserver";
    public static final String DB_DB2 = "db2";
    public static final String DB_TEIID = "teiid";
    @Inject
    protected HibernateSessionFactoryProvider hibernateSessionFactoryProvider;
    @Inject
    protected DatabaseAutoSynchronizer databaseAutoSynchronizer;
    @Inject
    protected DataSourceManager databaseSourceManager;
    @Inject
    @Config(value="h2=org.hibernate.dialect.H2Dialect,postgres=org.hibernate.dialect.PostgreSQLDialect,oracle=org.hibernate.dialect.Oracle10gDialect,mysql=org.hibernate.dialect.MySQLDialect,sqlserver=org.hibernate.dialect.SQLServerDialect,db2=org.hibernate.dialect.DB2Dialect,teiid=org.teiid.dialect.TeiidDialect")
    protected Map<String, String> supportedDialects;
    @Inject
    @Config(value="org.hibernate.dialect.H2Dialect,org.hibernate.dialect.DB2Dialect,org.teiid.dialect.TeiidDialect")
    protected String[] nativeToSequenceReplaceableDialects;
    @Inject
    @Config(value="org.hibernate.dialect.MySQLDialect,org.hibernate.dialect.SQLServerDialect")
    protected String[] nativeToHiloReplaceableDialects;
    @Inject
    @Config(value="org.jboss.dashboard.ui.resources.Envelope,org.jboss.dashboard.ui.resources.Skin,org.jboss.dashboard.ui.resources.Layout,org.jboss.dashboard.ui.resources.GraphicElement")
    protected String[] verificationExcludedClassNames;
    protected Configuration hbmConfig;
    protected String databaseName;
    protected DataSource localDataSource;
    @Inject
    @Config
    protected String defaultSchema;

    public SessionFactory getSessionFactory() {
        return this.hibernateSessionFactoryProvider.getSessionFactory();
    }

    @Override
    public Priority getPriority() {
        return Priority.URGENT;
    }

    @Override
    public void start() throws Exception {
        String hbnCfgPath = Application.lookup().getBaseCfgDirectory() + File.separator + "hibernate.cfg.xml";
        this.hbmConfig = new Configuration().configure(new File(hbnCfgPath));
        this.databaseName = this.inferDatabaseName();
        log.info("The underlying database is: " + this.databaseName);
        String hbnDialect = this.supportedDialects.get(this.databaseName);
        this.hbmConfig.setProperty("hibernate.dialect", hbnDialect);
        this.loadHibernateDescriptors(this.hbmConfig);
        ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)this.hbmConfig.getProperties()).buildServiceRegistry();
        SessionFactory factory = this.hbmConfig.buildSessionFactory(serviceRegistry);
        this.hibernateSessionFactoryProvider.setSessionFactory(factory);
        if (StringUtils.isBlank((String)this.defaultSchema)) {
            String _defaultSchema = this.hbmConfig.getProperty("hibernate.default_schema");
            if (!StringUtils.isBlank((String)_defaultSchema)) {
                this.defaultSchema = _defaultSchema;
            }
        } else {
            this.hbmConfig.setProperty("hibernate.default_schema", this.defaultSchema);
        }
        if (this.databaseAutoSynchronizer != null) {
            this.databaseAutoSynchronizer.synchronize(this);
        }
        this.verifyHibernateConfig();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isOracleDatabase() {
        return this.isDatabase(DB_ORACLE);
    }

    public boolean isPostgresDatabase() {
        return this.isDatabase(DB_POSTGRES);
    }

    public boolean isSQLServerDatabase() {
        return this.isDatabase(DB_SQLSERVER);
    }

    public boolean isMySQLDatabase() {
        return this.isDatabase(DB_MYSQL);
    }

    public boolean isH2Database() {
        return this.isDatabase(DB_H2);
    }

    public boolean isDB2Database() {
        return this.isDatabase(DB_DB2);
    }

    public boolean isTeiidDatabase() {
        return this.isDatabase(DB_TEIID);
    }

    protected boolean isDatabase(String dbId) {
        return dbId.equals(this.databaseName);
    }

    public DataSource getLocalDataSource() throws Exception {
        if (this.localDataSource != null) {
            return this.localDataSource;
        }
        String jndiName = this.hbmConfig.getProperty("hibernate.connection.datasource");
        if (StringUtils.isBlank((String)jndiName)) {
            throw new Exception("Property 'hibernate.connection.datasource' not specified.");
        }
        JNDIDataSourceEntry jndiDS = new JNDIDataSourceEntry();
        jndiDS.setJndiPath(jndiName);
        this.localDataSource = jndiDS.getDataSource();
        return this.localDataSource;
    }

    protected String inferDatabaseName() throws Exception {
        String databaseName = this.inferDatabaseName(this.getLocalDataSource());
        if (StringUtils.isBlank((String)databaseName)) {
            throw new Exception("The underlying database is unknown or the system is unable to recognize it.");
        }
        return databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String inferDatabaseName(DataSource ds) throws Exception {
        Connection connection = null;
        try {
            connection = ds.getConnection();
            String dbProductName = connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (dbProductName.contains(DB_H2)) {
                String string = DB_H2;
                return string;
            }
            if (dbProductName.contains("postgre")) {
                String string = DB_POSTGRES;
                return string;
            }
            if (dbProductName.contains(DB_MYSQL)) {
                String string = DB_MYSQL;
                return string;
            }
            if (dbProductName.contains(DB_ORACLE)) {
                String string = DB_ORACLE;
                return string;
            }
            if (dbProductName.contains("microsoft") || dbProductName.contains(DB_SQLSERVER) || dbProductName.contains("sql server")) {
                String string = DB_SQLSERVER;
                return string;
            }
            if (dbProductName.contains(DB_DB2)) {
                String string = DB_DB2;
                return string;
            }
            if (dbProductName.contains(DB_TEIID)) {
                String string = DB_TEIID;
                return string;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return null;
    }

    protected void verifyHibernateConfig() throws Exception {
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                Map metadata = session.getSessionFactory().getAllClassMetadata();
                for (final AbstractEntityPersister persister : metadata.values()) {
                    final String className = persister.getName();
                    if (ArrayUtils.contains((Object[])HibernateInitializer.this.verificationExcludedClassNames, (Object)className)) continue;
                    log.debug("Verifying: " + className);
                    new HibernateTxFragment(true){

                        @Override
                        protected void txFragment(Session session) throws Exception {
                            try {
                                boolean usingOracle = HibernateInitializer.this.isOracleDatabase();
                                Query query = session.createQuery("from " + className + " c " + (usingOracle ? " where rownum < 6" : ""));
                                if (!usingOracle) {
                                    query.setMaxResults(5);
                                }
                                query.list();
                            }
                            catch (Exception e) {
                                log.error("Structure verification error for class " + className);
                                log.error("Error seems to affect table named " + persister.getTableName());
                                log.error("The following stack trace may help you to determine the current error cause: ", (Throwable)e);
                            }
                        }
                    }.execute();
                }
            }
        }.execute();
    }

    protected void loadHibernateDescriptors(Configuration hbmConfig) throws IOException {
        Set<File> jars = Application.lookup().getJarFiles();
        for (File jar : jars) {
            ZipFile zf = new ZipFile(jar);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith("hbm.xml") || entry.isDirectory()) continue;
                InputStream is = zf.getInputStream(entry);
                String xml = this.readXMLForFile(entryName, is);
                xml = this.processXMLContents(xml);
                hbmConfig.addXML(xml);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readXMLForFile(String fileName, InputStream is) throws IOException {
        String string;
        block7: {
            BufferedReader reader = null;
            try {
                String lineRead;
                reader = new BufferedReader(new InputStreamReader(is));
                StringBuffer fileContents = new StringBuffer();
                while ((lineRead = reader.readLine()) != null) {
                    fileContents.append(lineRead);
                }
                string = fileContents.toString();
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Error processing the Hibernate XML mapping descriptor: " + fileName, (Throwable)e);
                    return null;
                }
            }
            reader.close();
        }
        return string;
    }

    protected String processXMLContents(String fileContent) {
        String line;
        if (ArrayUtils.contains((Object[])this.nativeToSequenceReplaceableDialects, (Object)this.hbmConfig.getProperty("hibernate.dialect"))) {
            line = "class=\"sequence\" />";
            fileContent = StringUtils.replace((String)fileContent, (String)"class=\"native\"/>", (String)line);
            fileContent = StringUtils.replace((String)fileContent, (String)"class=\"native\" />", (String)line);
        }
        if (ArrayUtils.contains((Object[])this.nativeToHiloReplaceableDialects, (Object)this.hbmConfig.getProperty("hibernate.dialect"))) {
            line = "class=\"hilo\"><param name=\"table\">hibernate_unique_key</param><param name=\"column\">next_hi</param><param name=\"max_lo\">0</param></generator>";
            fileContent = StringUtils.replace((String)fileContent, (String)"class=\"native\"/>", (String)line);
            fileContent = StringUtils.replace((String)fileContent, (String)"class=\"native\" />", (String)line);
        }
        return fileContent;
    }

    public synchronized void evictAllCaches() {
        Cache cache = this.getSessionFactory().getCache();
        cache.evictQueryRegions();
        cache.evictEntityRegions();
        cache.evictCollectionRegions();
    }
}

