/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.Profiler;
import org.jboss.dashboard.profiler.RuntimeConstraint;
import org.jboss.dashboard.profiler.ThreadProfile;

public class ProfilerHelper {
    public static String printCurrentContext() {
        ThreadProfile threadProfile = Profiler.lookup().getCurrentThreadProfile();
        CodeBlockTrace blockInProgress = threadProfile.getCodeBlockInProgress();
        return blockInProgress.printContext(true);
    }

    public static void checkRuntimeConstraints() {
        ThreadProfile threadProfile = Profiler.lookup().getCurrentThreadProfile();
        if (threadProfile == null) {
            return;
        }
        CodeBlockTrace blockInProgress = threadProfile.getCodeBlockInProgress();
        if (blockInProgress != null) {
            try {
                blockInProgress.checkRuntimeConstraints();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void addRuntimeConstraint(RuntimeConstraint constraint) {
        ThreadProfile threadProfile = Profiler.lookup().getCurrentThreadProfile();
        if (threadProfile == null) {
            return;
        }
        CodeBlockTrace blockInProgress = threadProfile.getCodeBlockInProgress();
        if (blockInProgress != null) {
            blockInProgress.addRuntimeConstraint(constraint);
        }
    }
}

