/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DirectoriesScanner {
    private String extension;
    private List<File> currentFiles = new ArrayList<File>();

    public DirectoriesScanner(String extension) {
        this.extension = "." + extension;
    }

    public File[] findFiles(File directory) {
        this.currentFiles.clear();
        this.scan(directory);
        return this.currentFiles.toArray(new File[this.currentFiles.size()]);
    }

    private void scan(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.scan(f);
                    continue;
                }
                if (!f.getName().endsWith(this.extension)) continue;
                this.currentFiles.add(f);
            }
        }
    }
}

