/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.jboss.dashboard.commons.text.StringUtil;

public class FileUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private FileUtil() {
    }

    public static boolean existFile(String fileName) {
        return new File(fileName).exists();
    }

    public static long compFileDate(String fileName1, String fileName2) {
        File file1 = new File(fileName1);
        File file2 = new File(fileName2);
        return file1.lastModified() - file2.lastModified();
    }

    public static boolean isUpdateFile(String fileName1, String fileName2) {
        File file1 = new File(fileName1);
        File file2 = new File(fileName2);
        if (!file1.exists()) {
            return file2.exists();
        }
        if (file2.exists()) {
            return file2.lastModified() - file1.lastModified() >= 0L;
        }
        return false;
    }

    public static void renameFile(String oldFileName, String newFileName) {
        File oldF = new File(oldFileName);
        File newF = new File(newFileName);
        oldF.renameTo(newF);
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        file.delete();
    }

    public static void replace(String file, String newfile, String cad, String newcad) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            buf.append(StringUtil.replaceAll(line, cad, newcad)).append("\n");
            line = reader.readLine();
        }
        reader.close();
        FileWriter fw = newfile == null || newfile.equals("") ? new FileWriter(file) : new FileWriter(newfile);
        BufferedWriter writer = new BufferedWriter(fw);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
        fw.close();
    }

    public static void replace(String file, String newfile, String[] cads, String[] newcads) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            buf.append(StringUtil.replaceAll(line, cads, newcads)).append("\n");
            line = reader.readLine();
        }
        reader.close();
        FileWriter fw = newfile == null || newfile.equals("") ? new FileWriter(file) : new FileWriter(newfile);
        BufferedWriter writer = new BufferedWriter(fw);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
        fw.close();
    }

    public static void makeBackupFile(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        String bakFile = extIndex == -1 ? fileName + ".bak" : fileName.substring(0, extIndex) + ".bak";
        if (FileUtil.existFile(bakFile)) {
            FileUtil.deleteFile(bakFile);
        }
        FileUtil.renameFile(fileName, bakFile);
    }

    public static void restoreBackupFile(String fileName) {
        int extIndex = fileName.lastIndexOf(46);
        String bakFile = extIndex == -1 ? fileName + ".bak" : fileName.substring(0, extIndex) + ".bak";
        if (FileUtil.existFile(fileName)) {
            FileUtil.deleteFile(fileName);
        }
        FileUtil.renameFile(bakFile, fileName);
    }

    public static byte[] readFile(String filename) throws FileNotFoundException, IOException {
        File file = new File(filename);
        FileInputStream stream = new FileInputStream(file);
        return FileUtil.readFromInputStream(stream);
    }

    public static byte[] readResourceFile(String fileName) throws FileNotFoundException, IOException {
        InputStream stream = null;
        File file = new File(fileName);
        stream = file.exists() ? new FileInputStream(fileName) : ClassLoader.getSystemResourceAsStream(fileName);
        if (stream == null) {
            throw new FileNotFoundException(fileName);
        }
        return FileUtil.readFromInputStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int copyBufferSize = 2048;
        try {
            int readSize;
            byte[] byteData = new byte[copyBufferSize];
            while ((readSize = is.read(byteData)) != -1) {
                out.write(byteData, 0, readSize);
            }
        }
        finally {
            is.close();
            out.close();
        }
        return out.toByteArray();
    }

    public static Vector readLines(String file) throws IOException {
        String line;
        Vector<String> contents = new Vector<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            contents.addElement(line);
        }
        in.close();
        return contents;
    }

    public static void writeLines(Vector lines, String file, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, append);
        PrintWriter fileOut = new PrintWriter(fos);
        for (int i = 0; i < lines.size(); ++i) {
            fileOut.println(lines.elementAt(i));
        }
        fileOut.flush();
        fileOut.close();
    }

    public static void appendToFile(String contents, String filename) throws FileNotFoundException, IOException {
        byte[] array = contents.getBytes();
        FileUtil.appendToFile(array, filename);
    }

    public static void appendToFile(byte[] contents, String filename) throws FileNotFoundException, IOException {
        FileOutputStream stream = new FileOutputStream(filename, true);
        stream.write(contents);
        stream.flush();
        stream.close();
    }

    public static boolean swapFile(String source, String tmp) {
        boolean result = true;
        File inputFile = new File(source);
        File sourceFile = new File(tmp);
        result &= inputFile.delete();
        return result &= sourceFile.renameTo(inputFile);
    }

    public static void copyFile(InputStream in, String destFile) throws IOException {
        FileUtil.copyFile(in, destFile, 4096);
    }

    public static void copyFile(String sourceFile, String destFile) throws IOException {
        FileUtil.copyFile(sourceFile, destFile, 4096);
    }

    public static void copyFile(String sourceFile, String destFile, int copyBufferSize) throws IOException {
        FileInputStream in = new FileInputStream(sourceFile);
        FileUtil.copyFile(in, destFile, copyBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream in, String destFile, int copyBufferSize) throws IOException {
        FileOutputStream out = new FileOutputStream(destFile);
        try {
            int readSize;
            byte[] data = new byte[copyBufferSize];
            while ((readSize = in.read(data)) != -1) {
                out.write(data, 0, readSize);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static void moveFile(String sourceFile, String destFile) throws IOException {
        FileUtil.moveFile(sourceFile, destFile, 4096);
    }

    public static void moveFile(InputStream in, String destFile) throws IOException {
        FileUtil.moveFile(in, destFile, 4096);
    }

    public static void moveFile(String sourceFile, String destFile, int moveBufferSize) throws IOException {
        FileInputStream in = new FileInputStream(sourceFile);
        FileUtil.moveFile(in, destFile, moveBufferSize);
        FileUtil.deleteFile(sourceFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(InputStream in, String destFile, int moveBufferSize) throws IOException {
        FileOutputStream out = new FileOutputStream(destFile);
        try {
            int readSize;
            byte[] data = new byte[moveBufferSize];
            while ((readSize = in.read(data)) != -1) {
                out.write(data, 0, readSize);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static String createDir(String dirName) {
        File file = new File(dirName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dirName;
    }

    public static boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public static String getTemporalFileName(String filePath) {
        String id;
        File tmpFile;
        boolean exists = false;
        do {
            id = new Long(System.currentTimeMillis()).toString();
        } while (exists = (tmpFile = new File(filePath + id)).exists());
        return id;
    }

    public static String changeSeparator(String p) {
        int indexS = p.indexOf(92);
        if (indexS > -1 && File.separatorChar != '\\') {
            p = p.replace('\\', File.separatorChar);
        }
        if ((indexS = p.indexOf(47)) > -1 && File.separatorChar != '/') {
            p = p.replace('/', File.separatorChar);
        }
        return p;
    }
}

