/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CursoredList
implements Serializable {
    private int DEFAULT_PAGE_SIZE = 10;
    private List list;
    private int pageNumber;
    private int pageSize;

    public CursoredList(List l) {
        this.list = l;
        this.pageNumber = 1;
        this.pageSize = this.DEFAULT_PAGE_SIZE;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) throws ArrayIndexOutOfBoundsException {
        this.pageNumber = pageNumber;
        if (pageNumber < 1) {
            throw new ArrayIndexOutOfBoundsException(pageNumber);
        }
        if (pageNumber > this.getNumberOfPages()) {
            throw new ArrayIndexOutOfBoundsException(pageNumber);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getNumberOfPages() {
        return (this.list.size() - 1) / this.pageSize + 1;
    }

    public List getPage() {
        int pageBegin = (this.pageNumber - 1) * this.pageSize;
        int pageEnd = pageBegin + this.pageSize;
        if (pageEnd > this.list.size()) {
            pageEnd = this.list.size();
        }
        ArrayList pageList = new ArrayList();
        for (int i = pageBegin; i < pageEnd; ++i) {
            pageList.add(this.list.get(i));
        }
        return pageList;
    }
}

