/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.filter;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.commons.filter.AbstractFilter;
import org.jboss.dashboard.commons.filter.FilterByCriteria;

public class SQLFilterByCriteria {
    protected FilterByCriteria filter;
    protected String sqlWildcard;
    private static SimpleDateFormat SQL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SQLFilterByCriteria() {
        this(new AbstractFilter(){

            @Override
            protected String formatForDisplay(String propertyId, Object value) {
                return null;
            }

            @Override
            protected String formatForComparison(String propertyId, Object value) {
                return null;
            }

            @Override
            protected Object getPropertyValue(String propertyId, Object obj) {
                return null;
            }
        });
    }

    public SQLFilterByCriteria(FilterByCriteria filter) {
        this.filter = filter;
        this.sqlWildcard = "%";
    }

    public String getSqlWildcard() {
        return this.sqlWildcard;
    }

    public String SQL_formatValue(Object value) {
        if (value instanceof Date) {
            return this.SQL_formatValue(SQL_DATE_FORMAT.format(value) + this.getSqlWildcard());
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            if (c.isEmpty()) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(this.SQL_formatValue(it.next()));
            }
            return buf.toString();
        }
        if (value instanceof String) {
            String allowedString = (String)value;
            if (allowedString.indexOf(this.getWildcard()) != -1) {
                allowedString = StringUtils.replace((String)allowedString, (String)this.getWildcard(), (String)this.getSqlWildcard());
            }
            return "'" + allowedString + "'";
        }
        return value.toString();
    }

    public String SQL_getWhereClause(String propertyId, String propertySQLName) {
        return this.SQL_getWhereClause(propertyId, propertySQLName, false);
    }

    public String SQL_getWhereClause(String propertyId, String sqlColumn, boolean ignoreCase) {
        if (!this.containsProperty(propertyId)) {
            return null;
        }
        List clause = this.SQL_getWhereClause(propertyId, sqlColumn, ignoreCase, false);
        if (clause == null) {
            return null;
        }
        return (String)clause.get(0);
    }

    public List SQL_getWhereClause(String propertyId, String sqlColumn, boolean ignoreCase, boolean forPreparedStatement) {
        if (!this.containsProperty(propertyId)) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        StringBuffer minValueBuf = new StringBuffer();
        Comparable minValue = this.getPropertyMinValue(propertyId);
        boolean minValueIncluded = this.minValueIncluded(propertyId);
        if (minValue != null) {
            minValueBuf.append(sqlColumn);
            if (minValueIncluded) {
                minValueBuf.append(">=");
            } else {
                minValueBuf.append(">");
            }
            if (forPreparedStatement) {
                minValueBuf.append("?");
            } else {
                minValueBuf.append(this.SQL_formatValue(minValue).replaceAll(this.getSqlWildcard(), ""));
            }
            results.add(minValue);
        }
        StringBuffer maxValueBuf = new StringBuffer();
        Comparable maxValue = this.getPropertyMaxValue(propertyId);
        boolean maxValueIncluded = this.maxValueIncluded(propertyId);
        if (maxValue != null) {
            maxValueBuf.append(sqlColumn);
            if (maxValueIncluded) {
                maxValueBuf.append("<=");
            } else {
                maxValueBuf.append("<");
            }
            if (forPreparedStatement) {
                maxValueBuf.append("?");
            } else {
                maxValueBuf.append(this.SQL_formatValue(maxValue).replaceAll(this.getSqlWildcard(), ""));
            }
            results.add(maxValue);
        }
        StringBuffer allowBuf = new StringBuffer();
        List allowedValues = this.getPropertyAllowedValues(propertyId);
        int allowMode = this.getPropertyAllowMode(propertyId);
        if (allowedValues != null && !allowedValues.isEmpty()) {
            String equalOperator = "";
            String likeOperator = "";
            String conjunction = "";
            switch (allowMode) {
                case 0: {
                    equalOperator = " = ";
                    likeOperator = " like ";
                    conjunction = " and ";
                    break;
                }
                case 1: {
                    equalOperator = " = ";
                    likeOperator = " like ";
                    conjunction = " or ";
                    break;
                }
                case 2: {
                    equalOperator = " <> ";
                    likeOperator = " not like ";
                    conjunction = " and ";
                }
            }
            Iterator it = allowedValues.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object allowedSQLValue = it.next();
                boolean isString = allowedSQLValue instanceof String;
                boolean useLike = false;
                String allowedSQLStr = null;
                if (forPreparedStatement) {
                    allowedSQLStr = "?";
                    Object arg = allowedSQLValue;
                    if (isString && arg.toString().indexOf(this.getWildcard()) != -1) {
                        useLike = true;
                        arg = StringUtils.replace((String)arg.toString(), (String)this.getWildcard(), (String)this.getSqlWildcard());
                    }
                    results.add(arg);
                } else {
                    allowedSQLStr = this.SQL_formatValue(allowedSQLValue);
                    boolean bl = useLike = allowedSQLStr.indexOf(this.getSqlWildcard()) != -1;
                }
                if (i > 0) {
                    allowBuf.append(conjunction);
                }
                if (ignoreCase && isString) {
                    allowBuf.append(" lower(");
                }
                allowBuf.append(sqlColumn);
                if (ignoreCase && isString) {
                    allowBuf.append(") ");
                }
                if (useLike && isString) {
                    allowBuf.append(likeOperator);
                } else {
                    allowBuf.append(equalOperator);
                }
                if (ignoreCase && isString) {
                    allowBuf.append(" lower(");
                }
                allowBuf.append(allowedSQLStr);
                if (ignoreCase && isString) {
                    allowBuf.append(") ");
                }
                ++i;
            }
        }
        String criteriaWhere = MessageFormat.format("(({0}) and ({1})) or ({2})", minValueBuf.toString(), maxValueBuf.toString(), allowBuf.toString());
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)"(() and ()) or ()", (String)"");
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)"(() and ()) or ", (String)"");
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)"() and ", (String)"");
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)"and ()", (String)"");
        if ((criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)" or ()", (String)"")).length() == 0) {
            return null;
        }
        results.add(0, criteriaWhere);
        return results;
    }

    public String SQL_getWhereClause(boolean exclusive, String[] propSQLClauses) {
        StringBuffer criteriaPattern = new StringBuffer();
        String andOr = exclusive ? " and " : " or ";
        for (int i = 0; i < propSQLClauses.length; ++i) {
            if (criteriaPattern.length() > 0) {
                criteriaPattern.append(andOr);
            }
            criteriaPattern.append("({").append(i).append("})");
        }
        String criteriaWhere = MessageFormat.format(criteriaPattern.toString(), propSQLClauses);
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)("(null)" + andOr), (String)"");
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)(andOr + "(null)"), (String)"");
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)("()" + andOr), (String)"");
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)(andOr + "()"), (String)"");
        criteriaWhere = StringUtils.replace((String)criteriaWhere, (String)"()", (String)"");
        return criteriaWhere;
    }

    public Locale getLocale() {
        return this.filter.getLocale();
    }

    public void setLocale(Locale locale) {
        this.filter.setLocale(locale);
    }

    public void addProperty(String propertyId, Object minValue, boolean minValueIncluded, Object maxValue, boolean maxValueIncluded, Collection allowedValues, int allowMode) {
        this.filter.addProperty(propertyId, minValue, minValueIncluded, maxValue, maxValueIncluded, allowedValues, allowMode);
    }

    public boolean addProperty(String propertyId, String filterCriteria) {
        return this.filter.addProperty(propertyId, filterCriteria);
    }

    public String[] getPropertyIds() {
        return this.filter.getPropertyIds();
    }

    public boolean containsProperty(String propertyId) {
        return this.filter.containsProperty(propertyId);
    }

    public boolean containsProperty(Collection propIds) {
        return this.filter.containsProperty(propIds);
    }

    public void removeProperty(String propertyId) {
        this.filter.removeProperty(propertyId);
    }

    public void removeAllProperty() {
        this.filter.removeAllProperty();
    }

    public int getPropertyPriority(String propertyId) {
        return this.filter.getPropertyPriority(propertyId);
    }

    public Comparable getPropertyMinValue(String propertyId) {
        return this.filter.getPropertyMinValue(propertyId);
    }

    public boolean minValueIncluded(String propertyId) {
        return this.filter.minValueIncluded(propertyId);
    }

    public Comparable getPropertyMaxValue(String propertyId) {
        return this.filter.getPropertyMaxValue(propertyId);
    }

    public boolean maxValueIncluded(String propertyId) {
        return this.filter.maxValueIncluded(propertyId);
    }

    public List getPropertyAllowedValues(String propertyId) {
        return this.filter.getPropertyAllowedValues(propertyId);
    }

    public int getPropertyAllowMode(String propertyId) {
        return this.filter.getPropertyAllowMode(propertyId);
    }

    public void setVariableName(String propertyId, String varName) {
        this.filter.setVariableName(propertyId, varName);
    }

    public String getVariableName(String propertyId) {
        return this.filter.getVariableName(propertyId);
    }

    public void setExtraInfo(String propertyId, String extraInfo) {
        this.filter.setExtraInfo(propertyId, extraInfo);
    }

    public String getExtraInfo(String propertyId) {
        return this.filter.getExtraInfo(propertyId);
    }

    public void setFilterCondition(String booleanExpression) {
        this.filter.setFilterCondition(booleanExpression);
    }

    public String getWildcard() {
        return this.filter.getWildcard();
    }

    public String getGt() {
        return this.filter.getGt();
    }

    public String getGtOrEq() {
        return this.filter.getGtOrEq();
    }

    public String getLt() {
        return this.filter.getLt();
    }

    public String getLtOrEq() {
        return this.filter.getLtOrEq();
    }

    public boolean pass(String propertyId, Object value) {
        return this.filter.pass(propertyId, value);
    }

    public boolean pass(Object obj) {
        return this.filter.pass(obj);
    }
}

