/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPooledDataSource
implements DataSource {
    private static transient Logger log = LoggerFactory.getLogger((String)NonPooledDataSource.class.getName());
    protected PrintWriter printWriter = new PrintWriter(System.out);
    protected int loginTimeOut = 0;
    protected String url;
    protected String user;
    protected String password;
    protected String driver;
    protected int isolation = 8;
    protected boolean autoCommit = false;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public int getIsolation() {
        return this.isolation;
    }

    public void setIsolation(int isolation) {
        this.isolation = isolation;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeOut;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeOut = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printWriter = out;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Class.forName(this.driver);
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            this.setAutoCommit(conn, this.autoCommit);
            this.setIsolation(conn, this.isolation);
            return conn;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return null;
    }

    protected boolean getAutoCommit(Connection conn) {
        try {
            return conn.getAutoCommit();
        }
        catch (SQLException e) {
            log.debug("Can not get autocommit.", (Throwable)e);
            return true;
        }
    }

    protected void setAutoCommit(Connection conn, boolean autocommit) {
        try {
            if (this.getAutoCommit(conn) != autocommit) {
                conn.setAutoCommit(autocommit);
            }
        }
        catch (SQLException e) {
            log.debug("Can not set autocommit.", (Throwable)e);
        }
    }

    protected void setIsolation(Connection conn, int isolation) {
        try {
            if (conn.getTransactionIsolation() != isolation) {
                conn.setTransactionIsolation(isolation);
            }
        }
        catch (SQLException e) {
            log.debug("Can not set connection isolation.", (Throwable)e);
        }
    }
}

