/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.mchange.v2.c3p0.impl.NewProxyConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.commons.dbcp.PoolableConnection;
import org.hibernate.HibernateException;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.commons.misc.ReflectionUtils;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="LOBHelper")
public class LOBHelper {
    private static transient Logger log = LoggerFactory.getLogger((String)LOBHelper.class.getName());
    private static final String ORACLE_CLASS = "oracle.sql.BLOB";
    private static final String ORACLE_TEMP_METHOD = "createTemporary";
    private static final String ORACLE_DURATION__SESSION = "DURATION_SESSION";
    private static final String ORACLE_JDBC_ORACLE_CONNECTION = "oracle.jdbc.OracleConnection";
    private static final String ORACLE_OPEN_METHOD = "open";
    private static final String ORACLE_MODE__READWRITE = "MODE_READWRITE";
    private static final String ORACLE_GET_BINARY_OUTPUT_STREAM = "getBinaryOutputStream";
    private static final String ORACLE_CLOSE = "close";

    public static LOBHelper lookup() {
        return (LOBHelper)CDIBeanLocator.getBeanByName("LOBHelper");
    }

    private Method getMethod(Class clazz, String method, Class c1, Class c2, Class c3) throws NoSuchMethodException {
        int nParams = 0;
        if (c3 != null) {
            nParams = 3;
        } else if (c2 != null) {
            nParams = 2;
        } else if (c1 != null) {
            nParams = 1;
        }
        Class[] types = new Class[nParams];
        if (c3 != null) {
            types[2] = c3;
        }
        if (c2 != null) {
            types[1] = c2;
        }
        if (c1 != null) {
            types[0] = c1;
        }
        return clazz.getDeclaredMethod(method, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oracleNullSafeSet(PreparedStatement statement, Object value, int index, ValueWriter vw) throws HibernateException, SQLException {
        try {
            Class<?> oracleBlobClass = Class.forName(ORACLE_CLASS);
            Method createTempMethod = this.getMethod(oracleBlobClass, ORACLE_TEMP_METHOD, Connection.class, Boolean.TYPE, Integer.TYPE);
            Field durationSession = oracleBlobClass.getField(ORACLE_DURATION__SESSION);
            Object[] arglist = new Object[3];
            Connection conn = statement.getConnection();
            arglist[0] = conn;
            arglist[1] = Boolean.TRUE;
            arglist[2] = durationSession.get(null);
            Object tempBlob = null;
            Class<?> connClassInCurrentClassLoader = Class.forName(conn.getClass().getName());
            if (Class.forName(ORACLE_JDBC_ORACLE_CONNECTION).isAssignableFrom(connClassInCurrentClassLoader)) {
                tempBlob = createTempMethod.invoke(null, arglist);
            } else if (WrappedConnection.class.isAssignableFrom(connClassInCurrentClassLoader)) {
                arglist[0] = ReflectionUtils.invokeMethod(conn, "getUnderlyingConnection", null);
                tempBlob = createTempMethod.invoke(null, arglist);
            } else if (NewProxyConnection.class.isAssignableFrom(connClassInCurrentClassLoader)) {
                NewProxyConnection castCon = (NewProxyConnection)conn;
                arglist[0] = C3P0ProxyConnection.RAW_CONNECTION;
                tempBlob = castCon.rawConnectionOperation(createTempMethod, C3P0ProxyConnection.RAW_CONNECTION, arglist);
            } else if (PoolableConnection.class.isAssignableFrom(connClassInCurrentClassLoader)) {
                arglist[0] = ((PoolableConnection)statement.getConnection()).getDelegate();
                tempBlob = createTempMethod.invoke(null, arglist);
            } else {
                boolean throwException = true;
                try {
                    String wasConnectionWrapper = "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection";
                    Class<?> wasConnectionWrapperClass = Class.forName(wasConnectionWrapper);
                    if (wasConnectionWrapperClass.isAssignableFrom(connClassInCurrentClassLoader)) {
                        String helperClass = "com.ibm.websphere.rsadapter.WSCallHelper";
                        Class<?> helper = Class.forName(helperClass);
                        Method nativeConnMethod = helper.getMethod("getNativeConnection", Object.class);
                        Connection nativeConn = (Connection)nativeConnMethod.invoke(null, conn);
                        if (Class.forName(ORACLE_JDBC_ORACLE_CONNECTION).isAssignableFrom(nativeConn.getClass())) {
                            arglist[0] = nativeConn;
                            tempBlob = createTempMethod.invoke(null, arglist);
                            throwException = false;
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (throwException) {
                    throw new HibernateException("JDBC connection object must be a oracle.jdbc.OracleConnection a " + WrappedConnection.class.getName() + "a " + PoolableConnection.class.getName() + "or a " + NewProxyConnection.class.getName() + ". Connection class is " + connClassInCurrentClassLoader.getName());
                }
            }
            Method openMethod = this.getMethod(oracleBlobClass, ORACLE_OPEN_METHOD, Integer.TYPE, null, null);
            Field fieldReadWrite = oracleBlobClass.getField(ORACLE_MODE__READWRITE);
            arglist = new Object[]{fieldReadWrite.get(null)};
            openMethod.invoke(tempBlob, arglist);
            Method getOutputStreamMethod = oracleBlobClass.getDeclaredMethod(ORACLE_GET_BINARY_OUTPUT_STREAM, null);
            OutputStream os = (OutputStream)getOutputStreamMethod.invoke(tempBlob, null);
            try {
                vw.writeValue(os, value);
                os.flush();
            }
            finally {
                os.close();
            }
            Method closeMethod = oracleBlobClass.getDeclaredMethod(ORACLE_CLOSE, null);
            closeMethod.invoke(tempBlob, null);
            statement.setBlob(index, (Blob)tempBlob);
        }
        catch (Exception e) {
            throw new HibernateException("Error in oracleNullSafeSet", (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, ValueWriter vw) throws HibernateException, SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Setting value of class " + (value == null ? "<null>" : value.getClass().getName()));
        }
        if (CoreServices.lookup().getHibernateInitializer().isOracleDatabase()) {
            this.oracleNullSafeSet(st, value, index, vw);
        } else {
            vw.writeValue(st, value, index);
        }
    }

    public static abstract class ValueWriter {
        public abstract void writeValue(OutputStream var1, Object var2) throws IOException;

        public abstract void writeValue(PreparedStatement var1, Object var2, int var3) throws SQLException;
    }
}

