/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.hibernate.HibernateSessionFactoryProvider;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.database.hibernate.HibernateWork;
import org.jboss.dashboard.error.ErrorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTransaction {
    private static transient Logger log = LoggerFactory.getLogger((String)HibernateTransaction.class.getName());
    private static transient ThreadLocal<HibernateTransaction> activeTx = new ThreadLocal();
    private String id = Thread.currentThread().getName();
    HibernateTxFragment currentFragment = null;
    List<HibernateTxFragment> listeners;
    List<HibernateTxFragment> followers = new ArrayList<HibernateTxFragment>();
    private Session session = null;
    private boolean active = false;
    private boolean rollback = false;
    private boolean completing = false;
    protected Transaction tx = null;

    public static HibernateTransaction getCurrentTx() {
        HibernateTransaction tx = activeTx.get();
        if (tx == null) {
            tx = new HibernateTransaction();
            activeTx.set(tx);
        }
        return tx;
    }

    private HibernateTransaction() {
        this.listeners = new ArrayList<HibernateTxFragment>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        this.rollback = rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    public void begin() throws Exception {
        try {
            log.debug("Begin transaction. Id=" + this.getId());
            HibernateSessionFactoryProvider hibernateSessionFactoryProvider = CoreServices.lookup().getHibernateSessionFactoryProvider();
            SessionFactory sessionFactory = hibernateSessionFactoryProvider.getSessionFactory();
            this.session = sessionFactory.openSession();
            this.tx = this.session.beginTransaction();
            this.active = true;
        }
        catch (HibernateException e) {
            this.error(e);
            throw e;
        }
    }

    public void complete() {
        if (!this.rollback) {
            this.flush();
        }
        this.completing = true;
        this.notifyListeners(true);
        if (this.rollback) {
            this.rollback();
        } else {
            this.commit();
        }
        this.completing = false;
        this.active = false;
        this.close();
        this.tx = null;
        activeTx.set(null);
        this.notifyListeners(false);
        this.processFollowers();
    }

    protected void flush() {
        try {
            log.debug("Flush transaction. Id=" + this.getId());
            this.session.flush();
        }
        catch (Throwable e) {
            log.debug("Flush error. Id=" + this.getId());
            this.error(e);
        }
    }

    protected void close() {
        try {
            log.debug("Close transaction. Id=" + this.getId());
            if (this.session.isOpen()) {
                this.session.close();
            }
        }
        catch (Throwable e) {
            log.error("Close error. Id=" + this.getId());
            this.error(e);
        }
    }

    protected void rollback() {
        try {
            log.debug("Rollback transaction. Id=" + this.getId());
            this.tx.rollback();
        }
        catch (Throwable e) {
            log.error("Error in rollback. Id=" + this.getId());
            this.rollback = false;
            this.error(e);
        }
    }

    protected void commit() {
        try {
            log.debug("Commit transaction. Id=" + this.getId());
            this.tx.commit();
        }
        catch (Throwable e) {
            log.error("Error in commit. Id=" + this.getId());
            this.error(e);
        }
    }

    public void error(Throwable t) {
        if (!this.rollback) {
            this.rollback = true;
            ErrorManager.lookup().notifyError(t, true);
        }
    }

    protected final void executeFragment(HibernateTxFragment fragment) throws Exception {
        FlushMode flushMode = this.session.getFlushMode();
        boolean flushChanged = false;
        try {
            fragment.parentFragment = this.currentFragment;
            this.currentFragment = fragment;
            HibernateTxFragment flusherFragment = this.getFlusherFragment();
            if (fragment == flusherFragment) {
                this.session.setFlushMode(FlushMode.COMMIT);
                flushChanged = true;
            }
            fragment.txFragment(this.session);
            if (fragment == flusherFragment) {
                log.debug("Flush transaction. Id=" + this.getId());
                this.session.flush();
            }
        }
        catch (Throwable t) {
            this.error(t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        finally {
            if (flushChanged) {
                this.session.setFlushMode(flushMode);
            }
            this.currentFragment = fragment.parentFragment;
            if (fragment.callbacksEnabled) {
                this.listeners.add(fragment);
                if (this.completing) {
                    this.notifyListener(true, fragment);
                }
            }
        }
    }

    protected HibernateTxFragment getFlusherFragment() {
        HibernateTxFragment setter = null;
        HibernateTxFragment fragment = this.currentFragment;
        while (fragment != null) {
            if (fragment.flushAfterFinish) {
                setter = fragment;
            }
            fragment = fragment.parentFragment;
        }
        return setter;
    }

    protected void notifyListeners(boolean before) {
        if (!this.listeners.isEmpty()) {
            log.debug((before ? "Before " : "After ") + (this.rollback ? "rollback" : "commit"));
        }
        for (HibernateTxFragment listener : new ArrayList<HibernateTxFragment>(this.listeners)) {
            boolean wasCommit = !this.rollback;
            this.notifyListener(before, listener);
            if (!before || !wasCommit || !this.rollback) continue;
            this.notifyListeners(true);
            break;
        }
    }

    protected void notifyListener(boolean before, HibernateTxFragment listener) {
        if (before) {
            if (this.rollback) {
                this.notifyBeforeRollback(listener);
            } else {
                this.notifyBeforeCommit(listener);
            }
        } else if (this.rollback) {
            this.notifyAfterRollback(listener);
        } else {
            this.notifyAfterCommit(listener);
        }
    }

    private void processFollowers() {
        for (HibernateTxFragment fragment : this.followers) {
            try {
                log.debug("Follower");
                fragment.execute();
            }
            catch (Throwable e) {
                log.error("Follower error. Id=" + this.getId(), e);
            }
        }
    }

    protected void notifyBeforeCommit(HibernateTxFragment fragment) {
        try {
            fragment.beforeCommit();
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    protected void notifyBeforeRollback(HibernateTxFragment fragment) {
        try {
            fragment.beforeRollback();
        }
        catch (Throwable e) {
            log.error("Error before rollback: ", e);
        }
    }

    protected void notifyAfterCommit(HibernateTxFragment fragment) {
        try {
            fragment.afterCommit();
        }
        catch (Throwable e) {
            log.error("Error after commit: ", e);
        }
    }

    protected void notifyAfterRollback(HibernateTxFragment fragment) {
        try {
            fragment.afterRollback();
        }
        catch (Throwable e) {
            log.error("Error after rollback: ", e);
        }
    }

    public static Object runWork(final HibernateWork work) throws Throwable {
        final Object[] result = new Object[]{null};
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Throwable {
                result[0] = work.doWork(session);
            }
        }.execute();
        return result[0];
    }
}

