/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIBeanLocator {
    public static BeanManager beanManager;
    public static CDIBeanLocator beanLocator;

    public static CDIBeanLocator get() {
        if (beanLocator == null) {
            beanLocator = new CDIBeanLocator();
        }
        return beanLocator;
    }

    public static BeanManager getBeanManager() {
        if (beanManager == null && (beanManager = CDIBeanLocator.lookupBeanManager("java:comp/BeanManager")) == null) {
            beanManager = CDIBeanLocator.lookupBeanManager("java:comp/env/BeanManager");
        }
        return beanManager;
    }

    private static BeanManager lookupBeanManager(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            return (BeanManager)initialContext.lookup(jndiName);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public static Object getBeanByName(String name) {
        return CDIBeanLocator.get().lookupBeanByName(name);
    }

    public static <T> T getBeanByType(Class<T> type) {
        return CDIBeanLocator.get().lookupBeanByType(type);
    }

    public static Object getBeanByType(String type) {
        return CDIBeanLocator.get().lookupBeanByType(type);
    }

    public static Object getBeanByNameOrType(String beanName) {
        return CDIBeanLocator.get().lookupBeanByNameOrType(beanName);
    }

    public Object lookupBeanByName(String name) {
        BeanManager bm = CDIBeanLocator.getBeanManager();
        Set beans = bm.getBeans(name);
        if (beans.isEmpty()) {
            throw new IllegalArgumentException("Bean not found by name: " + name);
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object o = bm.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return o;
    }

    public <T> T lookupBeanByType(Class<T> type) {
        BeanManager bm = CDIBeanLocator.getBeanManager();
        Set beans = bm.getBeans(type, new Annotation[0]);
        if (beans.isEmpty()) {
            throw new IllegalArgumentException("Bean not found by type: " + type.getName());
        }
        for (Bean bean : beans) {
            if (!bean.getBeanClass().equals(type)) continue;
            CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
            Object o = bm.getReference(bean, (Type)bean.getBeanClass(), ctx);
            return type.cast(o);
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object o = bm.getReference(bean, (Type)bean.getBeanClass(), ctx);
        return type.cast(o);
    }

    public Object lookupBeanByType(String type) {
        try {
            Class<?> beanClass = Class.forName(type);
            return this.lookupBeanByType(beanClass);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Object lookupBeanByNameOrType(String beanName) {
        try {
            Object beanObject = this.lookupBeanByName(beanName);
            if (beanObject != null) {
                return beanObject;
            }
            return null;
        }
        catch (Exception e) {
            return this.lookupBeanByType(beanName);
        }
    }
}

