/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.database;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.DataSourceEntry;
import org.jboss.dashboard.database.ExternalDataSource;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DataSourceManager {
    public static final String DEFAULT_DATASOURCE_NAME = "local";
    private static transient Logger log = LoggerFactory.getLogger((String)DataSourceManager.class.getName());

    @PostConstruct
    public void start() {
        for (DataSourceEntry entry : this.getDataSourceEntries()) {
            this.checkDriverClassAvailable(entry.getDriverClass());
        }
    }

    public boolean checkDriverClassAvailable(String driverClassName) {
        try {
            if (!StringUtils.isBlank((CharSequence)driverClassName)) {
                Class.forName(driverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Driver class not found: " + driverClassName);
            return false;
        }
        return true;
    }

    public List<String> getDataSourceNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DEFAULT_DATASOURCE_NAME);
        for (DataSourceEntry entry : this.getDataSourceEntries()) {
            names.add(entry.getName());
        }
        return names;
    }

    public List<DataSourceEntry> getDataSourceEntries() {
        final ArrayList<DataSourceEntry> result = new ArrayList<DataSourceEntry>();
        try {
            new HibernateTxFragment(){

                @Override
                protected void txFragment(Session session) throws Exception {
                    Query query = session.createQuery(" from " + DataSourceEntry.class.getName());
                    FlushMode oldFlushMode = session.getFlushMode();
                    session.setFlushMode(FlushMode.COMMIT);
                    query.setCacheable(true);
                    result.addAll(query.list());
                    session.setFlushMode(oldFlushMode);
                }
            }.execute();
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return result;
    }

    public DataSourceEntry getDataSourceEntry(final String name) throws Exception {
        if (name == null) {
            return null;
        }
        final ArrayList results = new ArrayList();
        new HibernateTxFragment(){

            @Override
            protected void txFragment(Session session) throws Exception {
                FlushMode flushMode = session.getFlushMode();
                session.setFlushMode(FlushMode.COMMIT);
                StringBuffer sql = new StringBuffer();
                sql.append("select dse ");
                sql.append("from ").append(DataSourceEntry.class.getName()).append(" as dse ");
                sql.append("where dse.name = :name");
                Query query = session.createQuery(sql.toString());
                query.setString("name", name);
                query.setCacheable(true);
                results.addAll(query.list());
                session.setFlushMode(flushMode);
            }
        }.execute();
        if (results.size() > 0) {
            if (results.size() > 1) {
                log.error("There are " + results.size() + " data sources with name=" + name);
            }
            return (DataSourceEntry)results.get(0);
        }
        log.debug("Does not exists data source with name: " + name);
        return null;
    }

    public DataSource getDataSource(String name) throws Exception {
        if (DEFAULT_DATASOURCE_NAME.equals(name)) {
            return CoreServices.lookup().getHibernateInitializer().getLocalDataSource();
        }
        DataSourceEntry entry = this.getDataSourceEntry(name);
        if (entry == null) {
            return null;
        }
        ExternalDataSource ds = new ExternalDataSource();
        ds.setName(name);
        ds.setDataSourceEntry(entry);
        ds.setDisableAutoCommit(false);
        return ds;
    }
}

