/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.text;

import java.awt.FontMetrics;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public final class StringUtil {
    public static final int LEFT_JUSTIFY = 0;
    public static final int RIGHT_JUSTIFY = 1;
    public static final int CENTER_JUSTIFY = 2;
    public static final String SPECIAL_CHARS = String.copyValueOf(new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00d7', '\u00f7'});
    public static final String TILDED_CHARS = String.copyValueOf(new char[]{'\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00c7', '\u00e7', '\u00d1', '\u00f1'});
    public static final String NON_TILDED_CHARS = "AAAAAEEEEIIIIOOOOOUUUUaaaaaeeeeiiiiooooouuuuCcNn";
    public static final String[] JAVA_KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    private StringUtil() {
    }

    public static String replace(String origStr, char oldChar, String newStr) {
        return StringUtil.replaceAll(origStr, oldChar, newStr);
    }

    public static String replaceAll(String origStr, char oldChar, String newStr) {
        if (origStr == null) {
            return null;
        }
        if (newStr == null) {
            return origStr;
        }
        StringBuffer buffer = new StringBuffer(origStr);
        int index = origStr.indexOf(oldChar);
        int insertPadding = 0;
        int padding = newStr.length() - 1;
        while (index > -1) {
            int replIndex = index + insertPadding;
            buffer.replace(replIndex, replIndex + 1, newStr);
            ++index;
            index = origStr.indexOf(oldChar, index);
            insertPadding += padding;
        }
        return buffer.toString();
    }

    public static String replaceFirst(String origStr, String oldStr, String newStr) {
        if (origStr == null) {
            return null;
        }
        if (oldStr == null || newStr == null) {
            return origStr;
        }
        String newText = null;
        int index = origStr.indexOf(oldStr);
        switch (index) {
            case -1: {
                return origStr;
            }
            case 0: {
                newText = newStr + origStr.substring(oldStr.length());
                return newText;
            }
        }
        newText = origStr.substring(0, index) + newStr + origStr.substring(index + oldStr.length());
        return newText;
    }

    public static String replace(String origStr, String oldStr, String newStr) {
        return StringUtil.replaceAll(origStr, oldStr, newStr);
    }

    public static String replaceAll(String origStr, String oldStr, String newStr) {
        if (origStr == null) {
            return null;
        }
        if (oldStr == null || newStr == null) {
            return origStr;
        }
        StringBuffer buf = new StringBuffer(origStr);
        int inicio = origStr.indexOf(oldStr);
        if (inicio == -1) {
            return origStr;
        }
        while (inicio != -1) {
            buf.replace(inicio, inicio + oldStr.length(), newStr);
            inicio = buf.toString().indexOf(oldStr, inicio + newStr.length());
        }
        return buf.toString();
    }

    public static String removeFirst(String origStr, String removeStr) {
        return StringUtil.replaceFirst(origStr, removeStr, "");
    }

    public static String removeAll(String origStr, String removeStr) {
        return StringUtil.replaceAll(origStr, removeStr, "");
    }

    public static Map replaceParamsValues(Map params, String oldSubstring, String newSubstring) {
        if (params == null) {
            return null;
        }
        HashMap newParams = new HashMap();
        for (Object param : params.keySet()) {
            Object value = params.get(param);
            if (value == null) continue;
            if (value instanceof String) {
                newParams.put(param, StringUtil.replaceAll(value.toString(), oldSubstring, newSubstring));
                continue;
            }
            newParams.put(param, (String)value);
        }
        return newParams;
    }

    public static String parseASCIITemplate(String template, Map params) {
        return StringUtil.parseASCIITemplate(template, params, "[#", "#]", true);
    }

    public static String parseASCIITemplate(String template, Map params, String leftMark, String rightMark) {
        return StringUtil.parseASCIITemplate(template, params, leftMark, rightMark, true);
    }

    public static String parseASCIITemplate(String template, Map params, String leftMark, String rightMark, boolean nullifyNotFound) {
        int leftIndex;
        if (params == null) {
            if (!nullifyNotFound) {
                return template;
            }
            params = new HashMap();
        }
        StringBuffer buffer = new StringBuffer(template);
        int rightIndex = 0;
        while ((leftIndex = StringUtil.indexOf(leftMark, rightIndex, buffer)) != -1 && (rightIndex = StringUtil.indexOf(rightMark, leftIndex + leftMark.length(), buffer)) != -1) {
            String param = buffer.substring(leftIndex + leftMark.length(), rightIndex);
            rightIndex += rightMark.length();
            if (params.containsKey(param)) {
                Object ref = params.get(param);
                String value = ref == null ? "null" : ref.toString();
                buffer.replace(leftIndex, rightIndex, value);
                rightIndex -= leftMark.length() + param.length() + rightMark.length();
                rightIndex += value.length();
                continue;
            }
            if (!nullifyNotFound) continue;
            String value = "null";
            buffer.replace(leftIndex, rightIndex, value);
            rightIndex -= leftMark.length() + param.length() + rightMark.length();
            rightIndex += value.length();
        }
        return buffer.toString();
    }

    public static int indexOf(String str, StringBuffer buf) {
        return StringUtil.indexOf(str, 0, buf);
    }

    public static int indexOf(String str, int fromIndex, StringBuffer buf) {
        if ((fromIndex = Math.max(fromIndex, 0)) >= buf.length()) {
            if (fromIndex == 0 && str.length() == 0) {
                return 0;
            }
            return -1;
        }
        if (str.length() == 0) {
            return fromIndex;
        }
        int max = buf.length() - str.length();
        int i = fromIndex;
        while (true) {
            int k;
            if (i <= max && buf.charAt(i) != str.charAt(0)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            for (k = 1; k < str.length() && buf.charAt(j) == str.charAt(k); ++k) {
                ++j;
            }
            if (k == str.length()) {
                return i;
            }
            ++i;
        }
    }

    public static String repeat(String str, int num) {
        StringBuffer str_ret = new StringBuffer(str.length() * num);
        for (int i = 0; i < num; ++i) {
            str_ret.append(str);
        }
        return str_ret.toString();
    }

    public static String firstUp(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static String firstLow(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }

    public static String lowerFirstUp(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length()).toLowerCase();
    }

    public static String trimUpperCase(String str) {
        return str.trim().toUpperCase();
    }

    public static String trimLowerCase(String str) {
        return str.trim().toLowerCase();
    }

    public static String findFirst(String str, String find) {
        int index = str.indexOf(find);
        if (index > -1) {
            return str.substring(0, index);
        }
        return str;
    }

    public static String findRest(String str, String find) {
        int index = str.indexOf(find);
        if (index > -1) {
            return str.substring(index + find.length());
        }
        return str;
    }

    public static String findLast(String str, String find) {
        int index = str.lastIndexOf(find);
        if (index > -1) {
            return str.substring(index + find.length());
        }
        return str;
    }

    public static Vector getTokensFromString(String str, String delimiter) {
        StringTokenizer st = new StringTokenizer(str, delimiter);
        Vector<String> vector = new Vector<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            vector.addElement(st.nextToken().trim());
        }
        return vector;
    }

    public static Vector getTokensFromString(String str) {
        if (str == null) {
            return new Vector();
        }
        StringTokenizer st = new StringTokenizer(str);
        Vector<String> vector = new Vector<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            vector.addElement(st.nextToken());
        }
        return vector;
    }

    public static String getStringFromTokens(Vector vector, String delimiter) {
        int nelem = vector.size();
        StringBuffer str_ret = new StringBuffer(nelem * delimiter.length());
        for (int i = 0; i < nelem; ++i) {
            str_ret.append(vector.elementAt(i));
            if (i >= nelem - 1) continue;
            str_ret.append(delimiter);
        }
        return str_ret.toString();
    }

    public static String subString(String str, int beginIndex, int endIndex) {
        return StringUtil.substring(str, beginIndex, endIndex);
    }

    public static String substring(String str, int beginIndex, int endIndex) {
        if (str.length() < endIndex) {
            endIndex = str.length();
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String indentParagraph(String textBefore, String textToModify) {
        int indexU = textBefore.lastIndexOf(10);
        return StringUtil.indentParagraph(textToModify, indexU + 1);
    }

    public static String indentParagraph(String textToModify, int indentSize) {
        if (indentSize > 0) {
            String blanks = StringUtil.repeat(" ", indentSize);
            int indexU = textToModify.indexOf(10);
            if (indexU > -1) {
                String textRest = textToModify;
                StringBuffer text = new StringBuffer();
                while (indexU > -1) {
                    String textBegin = textRest.substring(0, indexU + 1);
                    textRest = textRest.substring(indexU + 1).trim();
                    text.append(blanks).append(textBegin);
                    indexU = textRest.indexOf(10);
                }
                text.append(blanks).append(textRest);
                return text.toString();
            }
            return textToModify;
        }
        return textToModify;
    }

    public static String justify(String str, int size, int type) {
        int spaces = size - str.length();
        if (spaces <= 0) {
            return str.substring(0, size);
        }
        StringBuffer justifiedStr = new StringBuffer();
        switch (type) {
            case 1: {
                justifiedStr.append(StringUtil.repeat(" ", spaces));
                justifiedStr.append(str);
                break;
            }
            case 0: {
                justifiedStr.append(str);
                justifiedStr.append(StringUtil.repeat(" ", spaces));
                break;
            }
            case 2: {
                justifiedStr.append(StringUtil.repeat(" ", spaces / 2));
                justifiedStr.append(str);
                justifiedStr.append(StringUtil.repeat(" ", spaces - spaces / 2));
            }
        }
        return justifiedStr.toString();
    }

    public static String removeAll(String str, String[] substr) {
        if (str == null || substr == null) {
            return str;
        }
        StringBuffer buffer = new StringBuffer(str);
        int idx = 0;
        for (int i = 0; i < substr.length; ++i) {
            idx = 0;
            while ((idx = StringUtil.indexOf(substr[i], idx, buffer)) != -1) {
                buffer.replace(idx, idx + substr[i].length(), "");
            }
        }
        return buffer.toString();
    }

    private static String replaceAll(String str, String[] in, String out) {
        if (str == null || in == null || out == null) {
            return str;
        }
        StringBuffer buffer = new StringBuffer(str);
        int idx = 0;
        for (int i = 0; i < in.length; ++i) {
            idx = 0;
            while ((idx = StringUtil.indexOf(in[i], idx, buffer)) != -1) {
                buffer.replace(idx, idx + in[i].length(), out);
            }
        }
        return buffer.toString();
    }

    public static String replaceAll(String str, String[] in, String[] out) {
        if (str == null || in == null || out == null || in.length != out.length) {
            return str;
        }
        StringBuffer buffer = new StringBuffer(str);
        int idx = 0;
        for (int i = 0; i < in.length; ++i) {
            idx = 0;
            while ((idx = StringUtil.indexOf(in[i], idx, buffer)) != -1) {
                buffer.replace(idx, idx + in[i].length(), out[i]);
            }
        }
        return buffer.toString();
    }

    public static String replaceAll(String str, Vector in, Vector out, String beginDelim, String endDelim) {
        return StringUtil.replaceAll(str, (String[])in.toArray(), (String[])out.toArray(), beginDelim, endDelim);
    }

    public static String replaceAll(String str, String[] in, String[] out, String beginDelim, String endDelim) {
        if (in.length != out.length) {
            return str;
        }
        if (beginDelim.equals(endDelim)) {
            throw new IllegalArgumentException("beginDelim and endDelim are equals: " + beginDelim);
        }
        StringBuffer str_ret = new StringBuffer();
        int lastIndex = 0;
        int indexBegin = str.indexOf(beginDelim);
        int indexEnd = -1;
        int indexIn = -1;
        int index = -1;
        boolean found = false;
        int countIn = in.length;
        while (indexBegin > -1) {
            indexEnd = str.indexOf(endDelim, indexBegin);
            if (beginDelim.equals(endDelim) && beginDelim.equals("")) {
                ++indexEnd;
            } else {
                index = str.indexOf(beginDelim, indexBegin + beginDelim.length());
                while (index > -1 && index < indexEnd) {
                    indexBegin = index;
                    index = str.indexOf(beginDelim, indexBegin + beginDelim.length());
                }
            }
            String sFound = str.substring(indexBegin + beginDelim.length(), indexEnd);
            String lastSegment = str.substring(lastIndex, indexBegin);
            String sOut = "";
            found = false;
            for (indexIn = 0; !found && indexIn < countIn; ++indexIn) {
                if (sFound.compareToIgnoreCase(in[indexIn]) != 0) continue;
                sOut = StringUtil.indentParagraph(lastSegment, out[indexIn]);
                found = true;
            }
            if (!found) {
                sOut = beginDelim + sFound + endDelim;
            }
            if (found && sOut.compareTo("") == 0 && (index = lastSegment.lastIndexOf(10)) > -1 && lastSegment.substring(index + 1).trim().compareTo("") == 0) {
                lastSegment = lastSegment.substring(0, index);
            }
            str_ret.append(lastSegment).append(sOut);
            lastIndex = indexEnd + endDelim.length();
            indexBegin = str.indexOf(beginDelim, lastIndex);
        }
        if (lastIndex < str.length()) {
            str_ret.append(str.substring(lastIndex, str.length()));
        }
        return str_ret.toString();
    }

    public static String eliminateWordsShorterThan(String str, int size) {
        StringBuffer newStr = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(str);
        while (stringTokenizer.hasMoreTokens()) {
            String word = stringTokenizer.nextToken().trim();
            if (word.length() < size) continue;
            newStr.append(" ").append(word);
        }
        return newStr.toString().trim();
    }

    public static String filterSQLString(String str) {
        return StringUtil.replaceAll(str, "'", "''");
    }

    public static String makeSQLString(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        buf.append("'").append(StringUtil.filterSQLString(str)).append("'");
        return buf.toString();
    }

    public static String fill(String str, char ch, int size) {
        return StringUtil.fill(str, "" + ch, size, true);
    }

    public static String fill(String str, String strFill, int size) {
        return StringUtil.fill(str, strFill, size, true);
    }

    public static String fill(String str, String strFill, int size, boolean fillRight) {
        if (size <= str.length()) {
            return str;
        }
        int sizeGrow = size - str.length();
        int numTimes = sizeGrow / strFill.length();
        if (numTimes * strFill.length() < sizeGrow) {
            ++numTimes;
        }
        String append = StringUtil.repeat(strFill, numTimes).substring(0, sizeGrow);
        if (fillRight) {
            return str + append;
        }
        return append + str;
    }

    public static String[] cutString(String text, FontMetrics fontMetrics, int maxWidth) {
        Vector<String> strings = new Vector<String>(0, 10);
        text = text.trim();
        while (!text.trim().equals("")) {
            int cutPos = text.length();
            while (fontMetrics.stringWidth(text.substring(0, cutPos)) > maxWidth) {
                --cutPos;
            }
            int sepPos = cutPos - 1;
            boolean foundSep = false;
            if (cutPos != text.length()) {
                block5: while (sepPos > 0 && !foundSep) {
                    switch (text.charAt(sepPos)) {
                        case ' ': 
                        case ',': 
                        case '.': 
                        case ':': 
                        case ';': 
                        case '?': {
                            foundSep = true;
                            continue block5;
                        }
                    }
                    --sepPos;
                }
            }
            sepPos = !foundSep ? cutPos : ++sepPos;
            strings.addElement(text.substring(0, sepPos).trim());
            text = text.substring(sepPos, text.length()).trim();
        }
        String[] result = new String[strings.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)strings.elementAt(i);
        }
        return result;
    }

    public static String soundTrex(String original) {
        String result = original.toUpperCase();
        result = StringUtil.replaceAll(result, "CH", "TX");
        result = StringUtil.replaceAll(result, "V", "B");
        result = StringUtil.replaceAll(result, "NYA", "NA");
        result = StringUtil.replaceAll(result, "NYE", "NE");
        result = StringUtil.replaceAll(result, "NYI", "NI");
        result = StringUtil.replaceAll(result, "NYO", "NO");
        result = StringUtil.replaceAll(result, "NYU", "NU");
        result = StringUtil.replaceAll(result, "NB", "MB");
        result = StringUtil.replaceAll(result, "NP", "MP");
        result = StringUtil.replaceAll(result, "Z", "S");
        result = StringUtil.replaceAll(result, "CC", "CS");
        result = StringUtil.replaceAll(result, "H", "");
        result = StringUtil.replaceAll(result, "CI", "SI");
        result = StringUtil.replaceAll(result, "CE", "SE");
        result = StringUtil.replaceAll(result, "C", "K");
        result = StringUtil.replaceAll(result, "QU", "K");
        result = StringUtil.replaceAll(result, "V", "B");
        result = StringUtil.replaceAll(result, "LL", "I");
        result = StringUtil.replaceAll(result, "Y", "I");
        result = StringUtil.replaceAll(result, "J", "X");
        result = StringUtil.replaceAll(result, "GI", "XI");
        result = StringUtil.replaceAll(result, "GE", "XE");
        result = StringUtil.replaceAll(result, "GUI", "GI");
        result = StringUtil.replaceAll(result, "GUE", "GE");
        result = StringUtil.replaceAll(result, "L.L", "L");
        result = StringUtil.replaceAll(result, "\ufffd", "N");
        result = StringUtil.replaceAll(result, "\ufffd", "S");
        result = StringUtil.replaceAll(result, "RR", "R");
        result = StringUtil.replaceAll(result, "QUI", "KI");
        result = StringUtil.replaceAll(result, "QUE", "KE");
        result = StringUtil.replaceAll(result, "QUO", "KUO");
        result = StringUtil.replaceAll(result, "QUA", "KUA");
        result = StringUtil.replaceAll(result, "ADO", "AO");
        result = StringUtil.replaceAll(result, "ADA", "A");
        result = StringUtil.replaceAll(result, "ADE", "AE");
        result = StringUtil.replaceAll(result, "ADI", "AI");
        result = StringUtil.replaceAll(result, "-", " ");
        result = StringUtil.replaceAll(result, ":", "");
        result = " " + result + " ";
        result = StringUtil.replaceAll(result, "S ", "");
        result = StringUtil.replaceAll(result, "R ", "");
        result = StringUtil.replaceAll(result, "L ", "");
        result = StringUtil.replaceAll(result, " EL ", " ");
        result = StringUtil.replaceAll(result, " LA ", " ");
        result = StringUtil.replaceAll(result, " LO ", " ");
        result = StringUtil.replaceAll(result, " DE ", " ");
        result = StringUtil.replaceAll(result, " AL ", " ");
        result = StringUtil.replaceAll(result, " LE ", " ");
        result = StringUtil.replaceAll(result, " LOS ", " ");
        result = StringUtil.replaceAll(result, " LAS ", " ");
        result = StringUtil.replaceAll(result, " CON ", " ");
        result = StringUtil.replaceAll(result, " DEL ", " ");
        result = StringUtil.replaceAll(result, " VON ", " ");
        result = StringUtil.replaceAll(result, " VAN ", " ");
        result = StringUtil.replaceAll(result, " DER ", " ");
        result = StringUtil.replaceAll(result, "AA", "A");
        result = StringUtil.replaceAll(result, "BB", "B");
        result = StringUtil.replaceAll(result, "CC", "C");
        result = StringUtil.replaceAll(result, "DD", "D");
        result = StringUtil.replaceAll(result, "EE", "E");
        result = StringUtil.replaceAll(result, "FF", "F");
        result = StringUtil.replaceAll(result, "GG", "G");
        result = StringUtil.replaceAll(result, "HH", "H");
        result = StringUtil.replaceAll(result, "II", "I");
        result = StringUtil.replaceAll(result, "JJ", "J");
        result = StringUtil.replaceAll(result, "KK", "K");
        result = StringUtil.replaceAll(result, "LL", "L");
        result = StringUtil.replaceAll(result, "MM", "M");
        result = StringUtil.replaceAll(result, "NN", "N");
        result = StringUtil.replaceAll(result, "\ufffd\ufffd", "\ufffd");
        result = StringUtil.replaceAll(result, "OO", "O");
        result = StringUtil.replaceAll(result, "PP", "P");
        result = StringUtil.replaceAll(result, "QQ", "Q");
        result = StringUtil.replaceAll(result, "RR", "R");
        result = StringUtil.replaceAll(result, "SS", "S");
        result = StringUtil.replaceAll(result, "TT", "T");
        result = StringUtil.replaceAll(result, "UU", "U");
        result = StringUtil.replaceAll(result, "VV", "V");
        result = StringUtil.replaceAll(result, "WW", "W");
        result = StringUtil.replaceAll(result, "XX", "X");
        result = StringUtil.replaceAll(result, "YY", "Y");
        result = StringUtil.replaceAll(result, "ZZ", "Z");
        result = StringUtil.replaceAll(result, "\ufffd\ufffd", "\ufffd");
        result = result.trim();
        result = StringUtil.replaceAll(result, "  ", " ");
        return result;
    }

    public static String chomp(char[] charArray) {
        int endIndex;
        int length = charArray.length;
        for (int i = endIndex = charArray.length - 1; i > -1 && (charArray[i] == '\r' || charArray[i] == '\n'); --i) {
            --length;
        }
        return new String(charArray, 0, length);
    }

    public static int ocurrencesOf(String str, char chr) {
        int length = str.length();
        int numOcurrences = 0;
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) != chr) continue;
            ++numOcurrences;
        }
        return numOcurrences;
    }

    public static String lowerFirstLetter(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String upperFirstLetter(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String toJavaIdentifier(String str) {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        StringBuffer buf = new StringBuffer(str);
        int bufIdx = 0;
        while (bufIdx < buf.length()) {
            char c = buf.charAt(bufIdx);
            int tilded = TILDED_CHARS.indexOf(c);
            if (tilded != -1 && tilded < NON_TILDED_CHARS.length()) {
                buf.deleteCharAt(bufIdx);
                c = NON_TILDED_CHARS.charAt(tilded);
                buf.insert(bufIdx++, c);
                continue;
            }
            int special = SPECIAL_CHARS.indexOf(c);
            if (special != -1 || !Character.isJavaIdentifierPart(c)) {
                buf.deleteCharAt(bufIdx);
                continue;
            }
            ++bufIdx;
        }
        if (buf.length() == 0) {
            return "";
        }
        while (buf.length() > 0 && !Character.isJavaIdentifierStart(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        String javaId = buf.toString();
        if (StringUtil.isJavaKeyword(javaId)) {
            javaId = javaId.equals("class") ? "clazz" : '_' + javaId;
        }
        return javaId;
    }

    public static boolean isJavaIdentifier(String str) {
        boolean valid;
        boolean bl = valid = str != null && str.length() > 0;
        if (valid) {
            char c = str.charAt(0);
            valid = Character.isJavaIdentifierStart(c);
            int i = str.length();
            while (valid && --i >= 1) {
                valid = Character.isJavaIdentifierPart(c);
            }
        }
        return valid && !StringUtil.isJavaKeyword(str);
    }

    public static final boolean isJavaKeyword(String name) {
        if (name == null) {
            return false;
        }
        for (String KEYWORD : JAVA_KEYWORDS) {
            if (!KEYWORD.equals(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isJavaPackage(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return true;
        }
        if (".".equals(name)) {
            return false;
        }
        if (name.startsWith(".") || name.endsWith(".")) {
            return false;
        }
        boolean valid = true;
        String[] packageNameParts = name.split("\\.");
        for (int i = 0; i < packageNameParts.length; ++i) {
            String packageNamePart = packageNameParts[i];
            valid &= StringUtil.isJavaIdentifier(packageNamePart);
        }
        return valid;
    }

    public static String toJavaPackagePath(String packageName) {
        if (StringUtils.isBlank((CharSequence)packageName)) {
            return packageName;
        }
        if (!StringUtil.isJavaPackage(packageName)) {
            String message = "Package name: " + packageName + " is not valid";
            throw new IllegalArgumentException(message);
        }
        return packageName.replace('.', File.separatorChar);
    }

    public static String toJavaClassName(String name) {
        if (name == null || name.length() <= 0) {
            return name;
        }
        int colon = name.indexOf(58);
        if (colon != -1) {
            return StringUtil.upperFirstLetter(StringUtil.toJavaIdentifier(name.substring(colon + 1)));
        }
        return StringUtil.upperFirstLetter(StringUtil.toJavaIdentifier(name));
    }

    public static String toJavaFieldName(String name) {
        if (name == null) {
            return null;
        }
        return StringUtil.lowerFirstLetter(StringUtil.toJavaIdentifier(name));
    }

    public static String fixUnicodeCharacters(String name) {
        name = name.replaceAll("\u00c1", "A");
        name = name.replaceAll("\u00c9", "E");
        name = name.replaceAll("\u00cd", "I");
        name = name.replaceAll("\u00d3", "O");
        name = name.replaceAll("\u00da", "U");
        name = name.replaceAll("\u00e1", "a");
        name = name.replaceAll("\u00e9", "e");
        name = name.replaceAll("\u00ed", "i");
        name = name.replaceAll("\u00f3", "o");
        name = name.replaceAll("\u00fa", "u");
        name = name.replaceAll("\u00f1", "n");
        name = name.replaceAll("\u00d1", "N");
        name = name.replaceAll("\u00dc", "U");
        name = name.replaceAll("\u00fc", "u");
        name = name.replaceAll("\u00d2", "O");
        name = name.replaceAll("\u00f2", "o");
        name = name.replaceAll("\u00cf", "I");
        name = name.replaceAll("\u00c0", "A");
        name = name.replaceAll("\u00e0", "a");
        name = name.replaceAll("\u00c7", "C");
        name = name.replaceAll("\u00c8", "\u00e8");
        name = name.replaceAll("\u00e7", "c");
        name = name.replaceAll("/", "_");
        name = name.replaceAll("\\\\", "_");
        return name;
    }

    public static String replaceUnicodeCharacters(String str) {
        StringBuffer ostr = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
                continue;
            }
            ostr.append("\\u");
            String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                ostr.append("0");
            }
            ostr.append(hex.toLowerCase());
        }
        return ostr.toString();
    }

    public static String escapeQuotes(String str) {
        if (str == null) {
            return "";
        }
        str = StringUtils.replace((String)str, (String)"'", (String)"\\'");
        str = StringUtils.replace((String)str, (String)"\"", (String)"\\'");
        return str;
    }

    public static void main(String[] args) {
        System.out.println("---- Identifier ----");
        System.out.println(StringUtil.toJavaIdentifier("pepe"));
        System.out.println(StringUtil.toJavaIdentifier("Pepe"));
        System.out.println(StringUtil.toJavaIdentifier("long"));
        System.out.println(StringUtil.toJavaIdentifier("000000long"));
        System.out.println(StringUtil.toJavaIdentifier("000000kk"));
        System.out.println("---- Class ----");
        System.out.println(StringUtil.toJavaClassName("pepe"));
        System.out.println(StringUtil.toJavaClassName("Pepe"));
        System.out.println(StringUtil.toJavaClassName("class"));
        System.out.println(StringUtil.toJavaClassName("long"));
        System.out.println(StringUtil.toJavaClassName("0000long"));
        System.out.println(StringUtil.toJavaClassName("0000kk"));
        System.out.println(StringUtil.toJavaClassName("kXXX"));
        System.out.println("---- Field ----");
        System.out.println(StringUtil.toJavaFieldName("pepe"));
        System.out.println(StringUtil.toJavaFieldName("Pepe"));
        System.out.println(StringUtil.toJavaFieldName("class"));
        System.out.println(StringUtil.toJavaFieldName("Long"));
        System.out.println(StringUtil.toJavaFieldName("0000Long"));
        System.out.println(StringUtil.toJavaFieldName("0000kk"));
    }
}

