/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.initialModule;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.jboss.dashboard.Application;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.DataSourceEntry;
import org.jboss.dashboard.database.DataSourceManager;
import org.jboss.dashboard.export.DataSourceImportManager;
import org.jboss.dashboard.initialModule.InitialModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceIInitialModule
extends InitialModule {
    private static transient Logger log = LoggerFactory.getLogger((String)DataSourceIInitialModule.class.getName());
    protected String importFile;

    public String getImportFile() {
        return this.importFile;
    }

    public void setImportFile(String importFile) {
        this.importFile = importFile;
    }

    @Override
    protected boolean install() {
        return this.installOrUpgrade(false);
    }

    @Override
    protected boolean upgrade(long currentVersion) {
        long newVersion = this.getVersion();
        if (newVersion <= currentVersion) {
            return false;
        }
        return this.installOrUpgrade(true);
    }

    protected boolean installOrUpgrade(boolean upgrade) {
        try {
            if (!this.check()) {
                return false;
            }
            log.info("Parsing datasource XML file: " + this.importFile);
            Application cm = Application.lookup();
            File pf = new File(cm.getBaseAppDirectory() + File.separator + this.importFile);
            if (!pf.exists()) {
                log.error("Cannot find file " + this.importFile + " for datasource initial module.");
                return false;
            }
            DataSourceImportManager dataSourceImportManager = CoreServices.lookup().getDataSourceImportManager();
            DataSourceEntry entry = dataSourceImportManager.doImport(new BufferedInputStream(new FileInputStream(pf)));
            DataSourceManager dataSourceManager = CoreServices.lookup().getDataSourceManager();
            DataSourceEntry existingEntry = dataSourceManager.getDataSourceEntry(entry.getName());
            if (entry != null && existingEntry != null) {
                log.info("Datasource with name " + entry.getName() + " already exists. Overriding it.");
                existingEntry.delete();
            }
            if (entry != null) {
                entry.save();
            }
            return true;
        }
        catch (Exception e) {
            log.error("Error importing datasource file (" + this.importFile + ") from initial module.", (Throwable)e);
            return false;
        }
    }

    protected boolean check() {
        boolean correct = true;
        if (this.importFile == null) {
            log.error("Error. Import file not defined for initial module.");
            correct = false;
        }
        return correct;
    }
}

