/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.dashboard.commons.filter.AbstractFilter;
import org.jboss.dashboard.profiler.ThreadProfile;

public class ThreadProfileFilter
extends AbstractFilter {
    private static DecimalFormat _numberComparisonFormat = new DecimalFormat("00000000000000000000000000000000000000000000000000.0000000000");
    public static final SimpleDateFormat _dateComparisonFormat = new SimpleDateFormat("yyyyMMddHHmm");

    @Override
    protected String formatForDisplay(String propertyId, Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    protected String formatForComparison(String propertyId, Object value) {
        if (value instanceof Number) {
            return _numberComparisonFormat.format(value);
        }
        if (value instanceof Date) {
            return _dateComparisonFormat.format((Date)value);
        }
        return this.formatForDisplay(propertyId, value);
    }

    @Override
    protected Object getPropertyValue(String propertyId, Object obj) {
        try {
            ThreadProfile tp = (ThreadProfile)obj;
            return tp.getContextProperty(propertyId);
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

