/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.profiler.memory;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;

@ApplicationScoped
public class SizeEstimations {
    @Inject
    @Config(value="20")
    protected int sizeOfDate;
    @Inject
    @Config(value="24")
    protected int sizeOfTimestamp;
    @Inject
    @Config(value="9")
    protected int sizeOfBoolean;
    @Inject
    @Config(value="9")
    protected int sizeOfByte;
    @Inject
    @Config(value="10")
    protected int sizeOfShort;
    @Inject
    @Config(value="12")
    protected int sizeOfInteger;
    @Inject
    @Config(value="16")
    protected int sizeOfLong;
    @Inject
    @Config(value="12")
    protected int sizeOfFloat;
    @Inject
    @Config(value="16")
    protected int sizeOfDouble;
    @Inject
    @Config(value="32")
    protected int sizeOfBigDecimal;
    protected Map<Class, Integer> sizeOfMap = new HashMap<Class, Integer>();

    public static SizeEstimations lookup() {
        return CDIBeanLocator.getBeanByType(SizeEstimations.class);
    }

    @PostConstruct
    protected void init() {
        this.sizeOfMap.put(Date.class, this.getSizeOfDate());
        this.sizeOfMap.put(Timestamp.class, this.getSizeOfTimestamp());
        this.sizeOfMap.put(Boolean.class, this.getSizeOfBoolean());
        this.sizeOfMap.put(Byte.class, this.getSizeOfByte());
        this.sizeOfMap.put(Short.class, this.getSizeOfShort());
        this.sizeOfMap.put(Integer.class, this.getSizeOfInteger());
        this.sizeOfMap.put(Long.class, this.getSizeOfLong());
        this.sizeOfMap.put(Float.class, this.getSizeOfFloat());
        this.sizeOfMap.put(Double.class, this.getSizeOfDouble());
        this.sizeOfMap.put(BigDecimal.class, this.getSizeOfBigDecimal());
    }

    public int getSizeOfDate() {
        return this.sizeOfDate;
    }

    public void setSizeOfDate(int sizeOfDate) {
        this.sizeOfDate = sizeOfDate;
    }

    public int getSizeOfTimestamp() {
        return this.sizeOfTimestamp;
    }

    public void setSizeOfTimestamp(int sizeOfTimestamp) {
        this.sizeOfTimestamp = sizeOfTimestamp;
    }

    public int getSizeOfBoolean() {
        return this.sizeOfBoolean;
    }

    public void setSizeOfBoolean(int sizeOfBoolean) {
        this.sizeOfBoolean = sizeOfBoolean;
    }

    public int getSizeOfByte() {
        return this.sizeOfByte;
    }

    public void setSizeOfByte(int sizeOfByte) {
        this.sizeOfByte = sizeOfByte;
    }

    public int getSizeOfShort() {
        return this.sizeOfShort;
    }

    public void setSizeOfShort(int sizeOfShort) {
        this.sizeOfShort = sizeOfShort;
    }

    public int getSizeOfInteger() {
        return this.sizeOfInteger;
    }

    public void setSizeOfInteger(int sizeOfInteger) {
        this.sizeOfInteger = sizeOfInteger;
    }

    public int getSizeOfLong() {
        return this.sizeOfLong;
    }

    public void setSizeOfLong(int sizeOfLong) {
        this.sizeOfLong = sizeOfLong;
    }

    public int getSizeOfFloat() {
        return this.sizeOfFloat;
    }

    public void setSizeOfFloat(int sizeOfFloat) {
        this.sizeOfFloat = sizeOfFloat;
    }

    public int getSizeOfDouble() {
        return this.sizeOfDouble;
    }

    public void setSizeOfDouble(int sizeOfDouble) {
        this.sizeOfDouble = sizeOfDouble;
    }

    public int getSizeOfBigDecimal() {
        return this.sizeOfBigDecimal;
    }

    public void setSizeOfBigDecimal(int sizeOfBigDecimal) {
        this.sizeOfBigDecimal = sizeOfBigDecimal;
    }

    public int sizeOf(Object o) {
        if (o == null) {
            return 0;
        }
        Integer size = this.sizeOfMap.get(o.getClass());
        return size != null ? size : 0;
    }

    public int sizeOfString(String s) {
        if (s == null) {
            return 0;
        }
        return 40 + s.length() * 2;
    }
}

