/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.dashboard.annotation.config.Config;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.database.hibernate.HibernateTxFragment;
import org.jboss.dashboard.scheduler.PausableThreadPoolExecutor;
import org.jboss.dashboard.scheduler.SchedulerTask;
import org.jboss.dashboard.scheduler.SchedulerThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="scheduler")
public class Scheduler {
    private static transient Logger log = LoggerFactory.getLogger((String)Scheduler.class.getName());
    protected PausableThreadPoolExecutor executor;
    protected ThreadFactory threadFactory;
    protected Map<Object, SchedulerTask> scheduledTasks;
    @Inject
    @Config(value="10")
    protected int maxThreadPoolSize;
    @Inject
    @Config(value="true")
    protected boolean runOnStart;

    public static Scheduler lookup() {
        return (Scheduler)CDIBeanLocator.getBeanByName("scheduler");
    }

    @PostConstruct
    public void init() {
        this.scheduledTasks = Collections.synchronizedMap(new HashMap());
        this.threadFactory = new SchedulerThreadFactory();
        this.executor = new PausableThreadPoolExecutor(this.maxThreadPoolSize, this.threadFactory);
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        if (this.runOnStart) {
            log.debug("Scheduler started [pool size=" + this.maxThreadPoolSize + "].");
        } else {
            this.pause();
        }
    }

    @PreDestroy
    public void shutdown() {
        log.debug("Scheduler shutdown started.");
        this.executor.shutdown();
        log.debug("Scheduler shutdown completed.");
    }

    public boolean isRunOnStart() {
        return this.runOnStart;
    }

    public void setRunOnStart(boolean runOnStart) {
        this.runOnStart = runOnStart;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public void setMaxThreadPoolSize(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
        if (this.executor != null) {
            this.executor.setCorePoolSize(maxThreadPoolSize);
        }
    }

    public int getThreadPoolSize() {
        return this.executor.getPoolSize();
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public int getNumberOfScheduledTasks() {
        return this.scheduledTasks.size();
    }

    public int getNumberOfScheduledTasksInQueue() {
        return this.executor.getQueue().size();
    }

    public List<SchedulerTask> getScheduledTasks() {
        return new ArrayList<SchedulerTask>(this.scheduledTasks.values());
    }

    public List<SchedulerTask> getRunningTasks() {
        ArrayList<SchedulerTask> result = new ArrayList<SchedulerTask>();
        for (SchedulerTask task : this.scheduledTasks.values()) {
            if (!task.isRunning()) continue;
            result.add(task);
        }
        return result;
    }

    public List<SchedulerTask> getMisfiredTasks() {
        ArrayList<SchedulerTask> result = new ArrayList<SchedulerTask>();
        for (SchedulerTask task : this.scheduledTasks.values()) {
            if (!task.isMisfired()) continue;
            result.add(task);
        }
        return result;
    }

    public List<SchedulerTask> getWaitingTasks() {
        ArrayList<SchedulerTask> result = new ArrayList<SchedulerTask>();
        for (SchedulerTask task : this.scheduledTasks.values()) {
            if (task.isDone() || task.isRunning() || task.isMisfired()) continue;
            result.add(task);
        }
        return result;
    }

    public void pause() {
        this.executor.pause();
    }

    public void resume() {
        this.executor.resume();
    }

    public boolean isPaused() {
        return this.executor.isPaused();
    }

    public void execute(SchedulerTask task) {
        this.execute(task, true);
    }

    public void schedule(SchedulerTask task, Date date) {
        this.schedule(task, date, true);
    }

    public void schedule(SchedulerTask task, long seconds) {
        this.schedule(task, seconds, true);
    }

    public synchronized void execute(final SchedulerTask task, boolean onlyIfCommit) {
        try {
            if (onlyIfCommit) {
                new HibernateTxFragment(false, true){

                    @Override
                    protected void beforeCommit() throws Throwable {
                        Scheduler.this._schedule(task, null);
                    }
                }.execute();
            } else {
                this._schedule(task, null);
            }
        }
        catch (Exception e) {
            log.error("Execute call failed for task: " + task.getKey(), (Throwable)e);
        }
    }

    public synchronized void schedule(final SchedulerTask task, final Date date, boolean onlyIfCommit) {
        try {
            if (onlyIfCommit) {
                new HibernateTxFragment(false, true){

                    @Override
                    protected void beforeCommit() throws Throwable {
                        Scheduler.this._schedule(task, date);
                    }
                }.execute();
            } else {
                this._schedule(task, date);
            }
        }
        catch (Exception e) {
            log.error("Schedule call failed for task: " + task.getKey(), (Throwable)e);
        }
    }

    public synchronized void schedule(final SchedulerTask task, final long seconds, boolean onlyIfCommit) {
        try {
            if (onlyIfCommit) {
                new HibernateTxFragment(false, true){

                    @Override
                    protected void beforeCommit() throws Throwable {
                        Scheduler.this._schedule(task, seconds);
                    }
                }.execute();
            } else {
                this._schedule(task, seconds);
            }
        }
        catch (Exception e) {
            log.error("Schedule call failed for task: " + task.getKey(), (Throwable)e);
        }
    }

    public synchronized void unschedule(final String key) {
        try {
            new HibernateTxFragment(false, true){

                @Override
                protected void beforeCommit() throws Throwable {
                    Scheduler.this._unschedule(key);
                }
            }.execute();
        }
        catch (Exception e) {
            log.error("Unschedule call failed for task: " + key, (Throwable)e);
        }
    }

    public synchronized void unscheduleAll() {
        try {
            new HibernateTxFragment(false, true){

                @Override
                protected void beforeCommit() throws Throwable {
                    Scheduler.this._unscheduleAll();
                }
            }.execute();
        }
        catch (Exception e) {
            log.error("Unschedule all call failed.", (Throwable)e);
        }
    }

    public synchronized void fireTask(String key) {
        SchedulerTask task = this.scheduledTasks.get(key);
        if (task != null && !task.isDone() && !task.isRunning()) {
            try {
                task.run();
                log.debug("Task " + task + " executed.");
            }
            finally {
                this.scheduledTasks.remove(key);
                task.cancel();
                this._purge();
                if (task.isFixedDelay()) {
                    this.schedule(task, task.getFixedDelaySeconds());
                }
            }
        }
    }

    protected void _schedule(SchedulerTask task, Date date) {
        long delay = 10000L;
        if (date != null) {
            Date now = new Date();
            delay = date.getTime() - now.getTime();
            if (delay <= 0L) {
                throw new IllegalArgumentException("Delay is negative. The task can not be scheduled [" + task.toString() + "] Date=" + date);
            }
        }
        this._unschedule(task.getKey());
        task.future = this.executor.schedule(task, delay, TimeUnit.MILLISECONDS);
        this.scheduledTasks.put(task.getKey(), task);
        if (date == null) {
            log.debug("Task " + task + " execution requested.");
        } else {
            log.debug("Task " + task + " scheduled to: " + date);
        }
    }

    protected void _schedule(SchedulerTask task, long seconds) {
        this._unschedule(task.getKey());
        task.fixedDelay = true;
        task.fixedDelaySeconds = seconds;
        task.future = this.executor.scheduleWithFixedDelay(task, seconds, seconds, TimeUnit.SECONDS);
        this.scheduledTasks.put(task.getKey(), task);
        log.debug("Task " + task + " scheduled every " + seconds + " seconds.");
    }

    protected void _unschedule(String key) {
        SchedulerTask task = this.scheduledTasks.remove(key);
        if (task != null && !task.isDone() && !task.isRunning()) {
            task.cancel();
            this._purge();
            log.debug("Task " + task + " unscheduled.");
        }
    }

    public void _unscheduleAll() {
        Collection<SchedulerTask> tasks = this.scheduledTasks.values();
        for (SchedulerTask task : tasks) {
            if (task == null || task.isDone() || task.isRunning()) continue;
            task.cancel();
        }
        this.executor.purge();
        this.scheduledTasks.clear();
        log.debug("All tasks unscheduled.");
    }

    protected void _purge() {
        this.executor.purge();
        Iterator<SchedulerTask> it = this.scheduledTasks.values().iterator();
        while (it.hasNext()) {
            SchedulerTask task = it.next();
            if (!task.isDone()) continue;
            it.remove();
            log.debug("Task " + task + " purged.");
        }
    }

    public String printScheduledTasksReport() {
        HashMap<Object, SchedulerTask> temp = new HashMap<Object, SchedulerTask>(this.scheduledTasks);
        StringBuffer buf = new StringBuffer();
        buf.append("\n\n------------------ SCHEDULED TASKS=").append(temp.size()).append(" (Queue size=" + this.executor.getQueue().size() + ") -----------------------------\n");
        Set entries = temp.entrySet();
        for (Map.Entry entry : entries) {
            SchedulerTask task = (SchedulerTask)entry.getValue();
            buf.append("\n");
            if (task.isRunning()) {
                buf.append("RUNNING - ");
            } else if (task.isCancelled()) {
                buf.append("CANCELL - ");
            } else if (task.isDone()) {
                buf.append("COMPLTD - ");
            } else {
                buf.append("WAITING - [Firing in ").append(task.printTimeToFire()).append("] - ");
            }
            buf.append("[").append(task).append("]");
        }
        return buf.toString();
    }
}

