/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.commons.filter;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.dashboard.commons.comparator.ComparatorUtils;
import org.jboss.dashboard.commons.filter.FilterByCriteria;
import org.jboss.dashboard.commons.text.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilter
implements FilterByCriteria,
Cloneable {
    protected List filterProperties = new ArrayList();
    protected String filterCondition = null;
    protected String wildcard = "*";
    protected String gt = ">";
    protected String lt = "<";
    protected String gtOrEq = ">=";
    protected String ltOrEq = "<=";
    protected Locale locale = Locale.getDefault();
    protected transient Map _filterVarValues = new HashMap();
    protected transient ThreadLocal _bshIntepreterThread = new ThreadLocal();
    private static Logger log = LoggerFactory.getLogger(AbstractFilter.class);

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    @Override
    public String getGt() {
        return this.gt;
    }

    public void setGt(String gt) {
        this.gt = gt;
    }

    @Override
    public String getGtOrEq() {
        return this.gtOrEq;
    }

    public void setGtOrEq(String gtOrEq) {
        this.gtOrEq = gtOrEq;
    }

    @Override
    public String getLt() {
        return this.lt;
    }

    public void setLt(String lt) {
        this.lt = lt;
    }

    @Override
    public String getLtOrEq() {
        return this.ltOrEq;
    }

    public void setLtOrEq(String ltOrEq) {
        this.ltOrEq = ltOrEq;
    }

    public void merge(AbstractFilter other) {
        if (other != null) {
            String[] props;
            for (String prop : props = other.getPropertyIds()) {
                Comparable minValue = other.getPropertyMinValue(prop);
                Comparable maxValue = other.getPropertyMaxValue(prop);
                boolean minValueIncluded = other.minValueIncluded(prop);
                boolean maxValueIncluded = other.maxValueIncluded(prop);
                List allowedValues = other.getPropertyAllowedValues(prop);
                int allowMode = other.getPropertyAllowMode(prop);
                this.addProperty(prop, minValue, minValueIncluded, maxValue, maxValueIncluded, allowedValues, allowMode);
            }
        }
    }

    @Override
    public void addProperties(FilterByCriteria filter) {
        if (filter == null) {
            return;
        }
        String[] propIds = filter.getPropertyIds();
        for (int i = 0; i < propIds.length; ++i) {
            String propId = propIds[i];
            Comparable minValue = filter.getPropertyMinValue(propId);
            Comparable maxValue = filter.getPropertyMaxValue(propId);
            boolean minInc = filter.minValueIncluded(propId);
            boolean maxInc = filter.maxValueIncluded(propId);
            List allowed = filter.getPropertyAllowedValues(propId);
            int allowMode = filter.getPropertyAllowMode(propId);
            this.addProperty(propId, minValue, minInc, maxValue, maxInc, allowed, allowMode);
            this.setExtraInfo(propId, filter.getExtraInfo(propId));
            this.setVariableName(propId, this.getVariableName(propId));
        }
    }

    @Override
    public void addProperty(String propertyId, Object minValue, boolean minValueIncluded, Object maxValue, boolean maxValueIncluded, Collection allowedValues, int allowMode) {
        Object[] filterProps;
        Iterator it = this.filterProperties.iterator();
        while (it.hasNext()) {
            filterProps = (Object[])it.next();
            if (!filterProps[0].equals(propertyId.trim())) continue;
            it.remove();
        }
        filterProps = new Object[]{propertyId.trim(), minValue, minValueIncluded, maxValue, maxValueIncluded, allowedValues == null ? allowedValues : new ArrayList(allowedValues), new Integer(allowMode), StringUtil.toJavaIdentifier(propertyId.trim()), propertyId.trim()};
        this.filterProperties.add(filterProps);
        this.setFilterCondition(null);
    }

    @Override
    public boolean addProperty(String propertyId, String filterCriteria) {
        String[] filterValues;
        if (filterCriteria != null) {
            filterCriteria = filterCriteria.trim();
        }
        if ((filterValues = StringUtils.split((String)filterCriteria, (String)",")).length == 0) {
            return false;
        }
        String minValue = null;
        boolean minIncl = false;
        String maxValue = null;
        boolean maxIncl = false;
        HashSet<String> allowedValues = new HashSet<String>();
        for (int i = 0; i < filterValues.length; ++i) {
            String filterValue = filterValues[i];
            if (filterValue.startsWith(this.getGt())) {
                if (filterValue.startsWith(this.getGtOrEq())) {
                    minIncl = true;
                }
                filterValue = minIncl ? filterValue.substring(this.getGtOrEq().length()).trim() : filterValue.substring(this.getGt().length()).trim();
                minValue = filterValue;
                continue;
            }
            if (filterValue.startsWith(this.getLt())) {
                if (filterValue.startsWith(this.getLtOrEq())) {
                    maxIncl = true;
                }
                filterValue = maxIncl ? filterValue.substring(this.getLtOrEq().length()).trim() : filterValue.substring(this.getLt().length()).trim();
                maxValue = filterValue;
                continue;
            }
            allowedValues.add(filterValue);
        }
        this.addProperty(propertyId, minValue, minIncl, maxValue, maxIncl, allowedValues, 1);
        return true;
    }

    @Override
    public void removeProperty(String propertyId) {
        Object[] filterProps = this.getProperty(propertyId);
        if (filterProps != null) {
            this.filterProperties.remove(filterProps);
            this.setFilterCondition(null);
        }
    }

    @Override
    public void removeProperties(FilterByCriteria filter) {
        if (filter == null) {
            return;
        }
        String[] propIds = filter.getPropertyIds();
        for (int i = 0; i < propIds.length; ++i) {
            String propId = propIds[i];
            this.removeProperty(propId);
        }
    }

    @Override
    public void removeAllProperty() {
        this.filterProperties.clear();
        this.setFilterCondition(null);
    }

    @Override
    public int getPropertyPriority(String propertyId) {
        Object[] filterProps = this.getProperty(propertyId);
        if (filterProps != null) {
            return this.filterProperties.indexOf(filterProps) + 1;
        }
        return 0;
    }

    @Override
    public Comparable getPropertyMinValue(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return null;
        }
        return (Comparable)prop[1];
    }

    @Override
    public boolean minValueIncluded(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return false;
        }
        return (Boolean)prop[2];
    }

    @Override
    public Comparable getPropertyMaxValue(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return null;
        }
        return (Comparable)prop[3];
    }

    @Override
    public boolean maxValueIncluded(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return false;
        }
        return (Boolean)prop[4];
    }

    @Override
    public List getPropertyAllowedValues(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return new ArrayList();
        }
        return (List)prop[5];
    }

    @Override
    public int getPropertyAllowMode(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return 1;
        }
        return (Integer)prop[6];
    }

    @Override
    public void setVariableName(String propertyId, String varName) {
        Object[] propArray = this.getProperty(propertyId);
        if (propArray != null) {
            propArray[7] = varName;
        }
    }

    @Override
    public String getVariableName(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return null;
        }
        return (String)prop[7];
    }

    @Override
    public String getExtraInfo(String propertyId) {
        Object[] prop = this.getProperty(propertyId);
        if (prop == null) {
            return null;
        }
        return (String)prop[8];
    }

    @Override
    public void setExtraInfo(String propertyId, String extraInfo) {
        Object[] propArray = this.getProperty(propertyId);
        if (propArray != null) {
            propArray[8] = extraInfo;
        }
    }

    @Override
    public void setFilterCondition(String logicalExpression) {
        this.filterCondition = logicalExpression;
    }

    public String getFilterCondition() {
        if (this.filterCondition != null) {
            return this.filterCondition;
        }
        StringBuffer buf = new StringBuffer();
        for (Object[] filterProp : this.filterProperties) {
            if (buf.length() > 0) {
                buf.append(" AND ");
            }
            String varName = (String)filterProp[7];
            buf.append(StringUtil.toJavaIdentifier(varName));
        }
        return buf.toString();
    }

    @Override
    public String[] getPropertyIds() {
        String[] ids = new String[this.filterProperties.size()];
        for (int i = 0; i < ids.length; ++i) {
            Object[] filterProps = (Object[])this.filterProperties.get(i);
            ids[i] = (String)filterProps[0];
        }
        return ids;
    }

    @Override
    public boolean containsProperty(String propertyId) {
        return this.getProperty(propertyId) != null;
    }

    @Override
    public boolean containsProperty(Collection propIds) {
        if (propIds == null || propIds.isEmpty()) {
            return false;
        }
        Iterator it = propIds.iterator();
        while (it.hasNext()) {
            if (!this.containsProperty(it.next().toString())) continue;
            return true;
        }
        return false;
    }

    protected Object[] getProperty(String propertyId) {
        for (Object[] filterProps : this.filterProperties) {
            if (!filterProps[0].equals(propertyId.trim())) continue;
            return filterProps;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Object[] filterProp : this.filterProperties) {
            buf.append("Property ").append(filterProp[0]).append(": ");
            for (int i = 1; i < filterProp.length; ++i) {
                buf.append(filterProp[i]).append(" ");
            }
            buf.append("\r\n");
        }
        buf.append("Filter condition: ").append(this.filterCondition).append("");
        buf.append("\r\n");
        return buf.toString();
    }

    @Override
    public boolean pass(String propertyId, Object value) throws IllegalArgumentException {
        int allowMode;
        List allowedValues;
        Object maxValue;
        Object[] propertyFilter = this.getProperty(propertyId);
        Object minValue = propertyFilter[1];
        if (minValue != null) {
            boolean minValueIncluded = (Boolean)propertyFilter[2];
            if (value == null) {
                return false;
            }
            switch (this.compareBySimilarity(propertyId, minValue, value)) {
                case 1: {
                    return false;
                }
                case 0: {
                    if (minValueIncluded) break;
                    return false;
                }
            }
        }
        if ((maxValue = propertyFilter[3]) != null) {
            if (value == null) {
                return false;
            }
            boolean maxValueIncluded = (Boolean)propertyFilter[4];
            switch (this.compareBySimilarity(propertyId, maxValue, value)) {
                case -1: {
                    return false;
                }
                case 0: {
                    if (maxValueIncluded) break;
                    return false;
                }
            }
        }
        return this.pass(propertyId, value, allowedValues = (List)propertyFilter[5], allowMode = ((Integer)propertyFilter[6]).intValue());
    }

    public boolean pass(String propertyId, Object value, List allowedValues, int allowMode) {
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object aValue : values) {
                boolean pass = this.passValue(propertyId, aValue, allowedValues, allowMode);
                if (!pass) continue;
                return true;
            }
            return false;
        }
        return this.passValue(propertyId, value, allowedValues, allowMode);
    }

    public boolean passValue(String propertyId, Object value, List allowedValues, int allowMode) {
        if (allowedValues == null || allowedValues.isEmpty()) {
            return true;
        }
        boolean anySatisfied = false;
        block5: for (int i = 0; i < allowedValues.size(); ++i) {
            Object allowedObj = allowedValues.get(i);
            boolean valueSatisfied = this.compareBySimilarity(propertyId, allowedObj, value) == 0;
            switch (allowMode) {
                case 0: {
                    if (!valueSatisfied) {
                        return false;
                    }
                }
                case 1: {
                    if (!valueSatisfied) continue block5;
                    anySatisfied = true;
                    continue block5;
                }
                case 2: {
                    if (!valueSatisfied) continue block5;
                    return false;
                }
            }
        }
        return allowMode != 1 || anySatisfied;
    }

    protected int compareBySimilarity(String propertyId, Object pattern, Object value) {
        if (pattern instanceof String && ((String)pattern).indexOf(this.getWildcard()) != -1) {
            String s1 = this.formatForDisplay(propertyId, pattern).trim();
            String s2 = this.formatForDisplay(propertyId, value).trim();
            String target = StringUtil.replaceAll(s1, this.wildcard, "");
            if (s1.startsWith(this.wildcard) && s1.endsWith(this.wildcard) && s2.indexOf(target) != -1) {
                return 0;
            }
            if (s1.endsWith(this.wildcard) && s2.startsWith(target)) {
                return 0;
            }
            if (s1.startsWith(this.wildcard) && s2.endsWith(target)) {
                return 0;
            }
            return this.compare((Comparable)((Object)target), (Comparable)((Object)s2), 1);
        }
        if (value instanceof String) {
            String s1 = (String)value;
            String s2 = pattern != null ? pattern.toString() : null;
            return this.compare((Comparable)((Object)s1), (Comparable)((Object)s2), 1);
        }
        String s1 = this.formatForComparison(propertyId, pattern).trim();
        String s2 = this.formatForComparison(propertyId, value).trim();
        return this.compare((Comparable)((Object)s1), (Comparable)((Object)s2), 1);
    }

    @Override
    public synchronized boolean pass(Map obj) {
        if (obj == null || obj.isEmpty()) {
            return false;
        }
        String[] propIdArray = this.getPropertyIds();
        if (this.filterCondition == null) {
            for (int i = 0; i < propIdArray.length; ++i) {
                String propertyId = propIdArray[i];
                Object propertyValue = obj.get(propertyId);
                if (this.pass(propertyId, propertyValue)) continue;
                return false;
            }
            return true;
        }
        String filterCondition = this.getFilterCondition();
        filterCondition = StringUtil.replaceAll(filterCondition, "AND", "&&");
        filterCondition = StringUtil.replaceAll(filterCondition, "OR", "||");
        filterCondition = StringUtil.replaceAll(filterCondition, "NOT", "!");
        this._filterVarValues.clear();
        try {
            for (int i = 0; i < propIdArray.length; ++i) {
                String propertyId = propIdArray[i];
                String propertyVar = this.getVariableName(propertyId);
                Object propertyValue = obj.get(propertyId);
                Boolean propertyPassed = this.pass(propertyId, propertyValue);
                this._filterVarValues.put(propertyVar, propertyPassed);
            }
            Object result = this.executeBeanShellScript(filterCondition, this._filterVarValues);
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        catch (EvalError evalError) {
            log.error("Logical beanshell expression cannot be evaluated: " + filterCondition, (Throwable)evalError);
            return false;
        }
    }

    @Override
    public synchronized boolean pass(Object obj) {
        if (obj == null) {
            return false;
        }
        String[] propIdArray = this.getPropertyIds();
        if (this.filterCondition == null) {
            for (int i = 0; i < propIdArray.length; ++i) {
                String propertyId = propIdArray[i];
                Object propertyValue = this.getPropertyValue(propertyId, obj);
                if (this.pass(propertyId, propertyValue)) continue;
                return false;
            }
            return true;
        }
        String filterCondition = this.getFilterCondition();
        filterCondition = StringUtil.replaceAll(filterCondition, "AND", "&&");
        filterCondition = StringUtil.replaceAll(filterCondition, "OR", "||");
        filterCondition = StringUtil.replaceAll(filterCondition, "NOT", "!");
        this._filterVarValues.clear();
        try {
            for (int i = 0; i < propIdArray.length; ++i) {
                String propertyId = propIdArray[i];
                String propertyVar = this.getVariableName(propertyId);
                Object propertyValue = this.getPropertyValue(propertyId, obj);
                Boolean propertyPassed = this.pass(propertyId, propertyValue);
                this._filterVarValues.put(propertyId, propertyPassed);
                this._filterVarValues.put(propertyVar, propertyPassed);
            }
            Object result = this.executeBeanShellScript(filterCondition, this._filterVarValues);
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        catch (EvalError evalError) {
            log.error("Logical beanshell expression cannot be evaluated: " + filterCondition, (Throwable)evalError);
            return false;
        }
    }

    protected Object executeBeanShellScript(String beanShellScript, Map context) throws EvalError {
        if (beanShellScript == null || beanShellScript.trim().equals("")) {
            return null;
        }
        Interpreter bshInterpreter = (Interpreter)this._bshIntepreterThread.get();
        if (bshInterpreter == null) {
            bshInterpreter = new Interpreter();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                bshInterpreter.setClassLoader(loader);
            }
            this._bshIntepreterThread.set(bshInterpreter);
        }
        for (String contextVar : context.keySet()) {
            bshInterpreter.set(contextVar, context.get(contextVar));
        }
        return bshInterpreter.eval(beanShellScript);
    }

    public int compare(Comparable o1, Comparable o2, int ordering) {
        return ComparatorUtils.compare(o1, o2, ordering);
    }

    @Override
    public FilterByCriteria cloneFilter() {
        try {
            AbstractFilter clone = (AbstractFilter)super.clone();
            clone._filterVarValues = new HashMap();
            clone._bshIntepreterThread = new ThreadLocal();
            clone.filterProperties = new ArrayList();
            for (Object[] prop : this.filterProperties) {
                Collection allowedValues = (Collection)prop[5];
                clone.filterProperties.add(new Object[]{prop[0], prop[1], prop[2], prop[3], prop[4], allowedValues == null ? null : new ArrayList(allowedValues), prop[6], prop[7], prop[8]});
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Clone exception.", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        try {
            AbstractFilter other = (AbstractFilter)obj;
            if (this.filterProperties.size() != other.filterProperties.size()) {
                return false;
            }
            for (int i = 0; i < this.filterProperties.size(); ++i) {
                List otherAllowed;
                Object[] tprop = (Object[])this.filterProperties.get(i);
                String propId = (String)tprop[0];
                Object[] oprop = other.getProperty(propId);
                for (int j = 0; j < tprop.length; ++j) {
                    if (ComparatorUtils.compare(tprop[j], oprop[j], 1) == 0) continue;
                    return false;
                }
                List thisAllowed = this.getPropertyAllowedValues(propId);
                if (CollectionUtils.intersection((Collection)thisAllowed, (Collection)(otherAllowed = other.getPropertyAllowedValues(propId))).size() == thisAllowed.size()) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected abstract String formatForDisplay(String var1, Object var2);

    protected abstract String formatForComparison(String var1, Object var2);

    protected abstract Object getPropertyValue(String var1, Object var2);
}

