/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.export;

import java.io.InputStream;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.dashboard.database.DataSourceEntry;
import org.jboss.dashboard.database.JDBCDataSourceEntry;
import org.jboss.dashboard.database.JNDIDataSourceEntry;
import org.jboss.dashboard.export.InvalidDataSourceDefinition;

@ApplicationScoped
public class DataSourceImportManager {
    protected static final String PROPERTY_TYPE = "type";
    protected static final String PROPERTY_NAME = "name";
    protected static final String PROPERTY_JNDI = "jndiPath";
    protected static final String PROPERTY_URL = "jdbcUrl";
    protected static final String PROPERTY_DRIVER_CLASS = "driverClass";
    protected static final String PROPERTY_USER = "user";
    protected static final String PROPERTY_PASSWORD = "password";
    protected static final String PROPERTY_TEST_QUERY = "testQuery";
    public static final String DATASOURCE_EXTENSION = "datasource";

    public DataSourceEntry doImport(InputStream dataSourceInputStream) throws InvalidDataSourceDefinition, Exception {
        if (dataSourceInputStream == null) {
            return null;
        }
        Properties dataSourceProperties = new Properties();
        dataSourceProperties.load(dataSourceInputStream);
        String type = dataSourceProperties.getProperty(PROPERTY_TYPE);
        if (type == null || type.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Property type is not present in datasource definition.");
        }
        DataSourceEntry entry = null;
        if (type.equalsIgnoreCase(DataSourceType.JNDI.name())) {
            entry = this.createJNDIDatasource(dataSourceProperties);
        } else if (type.equalsIgnoreCase(DataSourceType.JDBC.name())) {
            entry = this.createJDBCDatasource(dataSourceProperties);
        } else {
            throw new InvalidDataSourceDefinition("The value '" + type + "' for property type is not supported.");
        }
        return entry;
    }

    protected JNDIDataSourceEntry createJNDIDatasource(Properties dataSourceProperties) throws InvalidDataSourceDefinition {
        String name = dataSourceProperties.getProperty(PROPERTY_NAME);
        String jndi = dataSourceProperties.getProperty(PROPERTY_JNDI);
        String testQuery = dataSourceProperties.getProperty(PROPERTY_TEST_QUERY);
        if (name == null || name.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Datasource name is not present in the datasource definition.");
        }
        if (jndi == null || jndi.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Datasource JNDI path is not present in the datasource definition.");
        }
        JNDIDataSourceEntry entry = new JNDIDataSourceEntry();
        entry.setName(name);
        entry.setJndiPath(jndi);
        entry.setTestQuery(testQuery);
        return entry;
    }

    protected JDBCDataSourceEntry createJDBCDatasource(Properties dataSourceProperties) throws InvalidDataSourceDefinition {
        String name = dataSourceProperties.getProperty(PROPERTY_NAME);
        String jdbc = dataSourceProperties.getProperty(PROPERTY_URL);
        String driver = dataSourceProperties.getProperty(PROPERTY_DRIVER_CLASS);
        String user = dataSourceProperties.getProperty(PROPERTY_USER);
        String password = dataSourceProperties.getProperty(PROPERTY_PASSWORD);
        String testQuery = dataSourceProperties.getProperty(PROPERTY_TEST_QUERY);
        if (name == null || name.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Datasource name is not present in the datasource definition.");
        }
        if (jdbc == null || jdbc.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Datasource JDBC path is not present in the datasource definition.");
        }
        if (driver == null || driver.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Datasource driver classname is not present in the datasource definition.");
        }
        if (user == null || user.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Datasource user is not present in the datasource definition.");
        }
        if (password == null || password.trim().length() == 0) {
            throw new InvalidDataSourceDefinition("Datasource password is not present in the datasource definition.");
        }
        JDBCDataSourceEntry entry = new JDBCDataSourceEntry();
        entry.setName(name);
        entry.setUrl(jdbc);
        entry.setDriverClass(driver);
        entry.setUserName(user);
        entry.setPassword(password);
        entry.setTestQuery(testQuery);
        return entry;
    }

    protected static enum DataSourceType {
        JNDI,
        JDBC;

    }
}

