/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.displayer;

import java.util.List;
import org.jboss.dashboard.displayer.DataDisplayer;
import org.jboss.dashboard.displayer.DataDisplayerRenderer;
import org.jboss.dashboard.displayer.DataDisplayerType;
import org.jboss.dashboard.provider.DataProvider;

public abstract class AbstractDataDisplayer
implements DataDisplayer {
    protected DataDisplayerType dataDisplayerType = null;
    protected DataDisplayerRenderer dataDisplayerRenderer = null;
    protected DataProvider dataProvider = null;

    protected AbstractDataDisplayer() {
    }

    @Override
    public DataDisplayerType getDataDisplayerType() {
        return this.dataDisplayerType;
    }

    @Override
    public void setDataDisplayerType(DataDisplayerType type) {
        this.dataDisplayerType = type;
    }

    @Override
    public void setDataProvider(DataProvider dp) {
        this.dataProvider = dp;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public DataDisplayerRenderer getDataDisplayerRenderer() {
        List<DataDisplayerRenderer> renderers = this.dataDisplayerType.getSupportedRenderers();
        if (this.dataDisplayerRenderer == null || !renderers.contains(this.dataDisplayerRenderer)) {
            this.dataDisplayerRenderer = this.dataDisplayerType.getDefaultRenderer();
        }
        return this.dataDisplayerRenderer;
    }

    @Override
    public void setDataDisplayerRenderer(DataDisplayerRenderer renderer) {
        List<DataDisplayerRenderer> renderers;
        if (renderer != null & (renderers = this.dataDisplayerType.getSupportedRenderers()).contains(renderer)) {
            this.dataDisplayerRenderer = renderer;
        }
    }

    @Override
    public void setDefaultSettings() {
        this.getDataDisplayerRenderer().setDefaultSettings(this);
    }

    @Override
    public void copyFrom(DataDisplayer sourceDisplayer) {
        try {
            AbstractDataDisplayer source = (AbstractDataDisplayer)sourceDisplayer;
            this.setDataDisplayerRenderer(source.getDataDisplayerRenderer());
            this.setDataProvider(source.getDataProvider());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

