/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.dashboard.function.ScalarFunction;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockType;
import org.jboss.dashboard.profiler.CoreCodeBlockTypes;

public abstract class AbstractFunction
implements ScalarFunction {
    protected int precission = -1;

    @Override
    public String getName(Locale l) {
        ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.displayer.messages", l);
        return i18n.getString("function." + this.getCode() + ".name");
    }

    @Override
    public String getDescription(Locale l) {
        ResourceBundle i18n = ResourceBundle.getBundle("org.jboss.dashboard.displayer.messages", l);
        return i18n.getString("function." + this.getCode() + ".description");
    }

    @Override
    public boolean isTypeSupported(Class type) {
        return true;
    }

    public double round(double value, int precission) {
        if (precission < 0) {
            return value;
        }
        double result = value * Math.pow(10.0, precission);
        long temp = Math.round(result);
        result = (double)temp / Math.pow(10.0, precission);
        return result;
    }

    static class ScalarFunctionTrace
    extends CodeBlockTrace {
        protected String funcCode;
        protected long valuesSize;

        public ScalarFunctionTrace(String funcCode, Collection values) {
            super("function-" + funcCode);
            this.funcCode = funcCode;
            this.valuesSize = values.size();
        }

        public CodeBlockType getType() {
            return CoreCodeBlockTypes.SCALAR_FUNCTION;
        }

        public String getDescription() {
            return this.funcCode + " scalar function";
        }

        public Map<String, Object> getContext() {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("#values", this.valuesSize);
            return ctx;
        }
    }
}

