/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.profiler;

import java.lang.ref.WeakReference;
import org.jboss.dashboard.commons.misc.Chronometer;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.DataSetException;
import org.jboss.dashboard.profiler.RuntimeConstraint;
import org.jboss.dashboard.profiler.memory.MemoryProfiler;

public class DataSetLoadConstraints
implements RuntimeConstraint {
    protected WeakReference<DataSet> dataSetRef;
    protected long startMemory;
    protected long startTime;

    public DataSetLoadConstraints(DataSet dataSet) {
        this.dataSetRef = new WeakReference<DataSet>(dataSet);
        MemoryProfiler memoryProfiler = MemoryProfiler.lookup().freeMemory();
        this.startMemory = memoryProfiler.getMemoryUsedInBytes();
        this.startTime = System.currentTimeMillis();
    }

    public void validate() throws Exception {
        DataSet dataSet = (DataSet)this.dataSetRef.get();
        MemoryProfiler memoryProfiler = MemoryProfiler.lookup().freeMemory();
        long memoryUsed = memoryProfiler.getMemoryUsedInBytes() - this.startMemory;
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long sizeInBytes = dataSet.sizeOf();
        long maxSize = dataSet.getDataProvider().getDataLoader().getMaxDataSetSizeInBytes();
        long maxTime = dataSet.getDataProvider().getDataLoader().getMaxDataSetLoadTimeInMillis();
        long maxMemUsed = dataSet.getDataProvider().getDataLoader().getMaxMemoryUsedInDataLoad();
        if (maxMemUsed > 0L && memoryUsed > maxMemUsed) {
            String total = MemoryProfiler.formatSize((long)maxMemUsed);
            throw new DataSetException("Data set load memory usage has been exceeded = " + total);
        }
        if (maxTime > 0L && elapsedTime > maxTime) {
            String time = Chronometer.formatElapsedTime((long)maxTime);
            throw new DataSetException("Data set load time has been exceeded = " + time);
        }
        if (maxSize > 0L && sizeInBytes > maxSize) {
            String size = MemoryProfiler.formatSize((long)maxSize);
            throw new DataSetException("Data set size in memory has been exceeded = " + size);
        }
    }
}

