/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.dashboard.annotation.Install;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.provider.DataPropertyFormatter;

@ApplicationScoped
@Named(value="dataFormatterRegistry")
public class DataFormatterRegistry {
    protected DataPropertyFormatter defaultPropertyFormatter;
    Map<String, DataPropertyFormatter> customFormatterMap;
    @Inject
    @Install
    protected Instance<DataPropertyFormatter> dataPropertyFormatters;

    public static DataFormatterRegistry lookup() {
        return (DataFormatterRegistry)CDIBeanLocator.getBeanByName((String)"dataFormatterRegistry");
    }

    @PostConstruct
    protected void init() {
        this.customFormatterMap = new HashMap<String, DataPropertyFormatter>();
        for (DataPropertyFormatter formatter : this.dataPropertyFormatters) {
            String[] propIds = formatter.getSupportedPropertyIds();
            if (propIds == null) {
                this.defaultPropertyFormatter = formatter;
                continue;
            }
            for (int i = 0; i < propIds.length; ++i) {
                String propId = propIds[i];
                this.customFormatterMap.put(propId, formatter);
            }
        }
    }

    public DataPropertyFormatter getPropertyFormatter(String propId) {
        DataPropertyFormatter propFormatter = this.customFormatterMap.get(propId);
        if (propFormatter != null) {
            return propFormatter;
        }
        return this.defaultPropertyFormatter;
    }
}

