/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.dashboard.dataset.AbstractDataSet;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.profiler.DataSetLoadConstraints;
import org.jboss.dashboard.domain.Domain;
import org.jboss.dashboard.domain.date.DateDomain;
import org.jboss.dashboard.domain.label.LabelDomain;
import org.jboss.dashboard.domain.numeric.NumericDomain;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.CodeBlockType;
import org.jboss.dashboard.profiler.CoreCodeBlockTypes;
import org.jboss.dashboard.profiler.RuntimeConstraint;
import org.jboss.dashboard.profiler.memory.MemoryProfiler;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.jboss.dashboard.provider.csv.CSVDataProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataSet
extends AbstractDataSet {
    protected CSVReader csvReader;
    protected CSVDataLoader csvLoader;
    protected transient DateFormat _dateFormat;
    protected transient DecimalFormat _numberFormat;
    protected static transient Logger log = LoggerFactory.getLogger(CSVDataSet.class);

    public CSVDataSet(DataProvider provider, CSVDataLoader loader) {
        super(provider);
        this.csvLoader = loader;
        DecimalFormatSymbols numberSymbols = new DecimalFormatSymbols();
        numberSymbols.setGroupingSeparator(this.csvLoader.getCsvNumberGroupSeparator());
        numberSymbols.setDecimalSeparator(this.csvLoader.getCsvNumberDecimalSeparator());
        this._numberFormat = new DecimalFormat("#,##0.00", numberSymbols);
        this._dateFormat = new SimpleDateFormat(this.csvLoader.getCsvDatePattern());
    }

    public CSVDataProperty createCSVProperty() {
        return new CSVDataProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        CSVReadTrace trace = new CSVReadTrace(this.csvLoader);
        trace.addRuntimeConstraint((RuntimeConstraint)new DataSetLoadConstraints((DataSet)this));
        trace.begin();
        try {
            File f = this.csvLoader.getCsvProviderFile();
            if (f == null || !f.exists() || !f.canRead()) {
                throw new IOException("Can't load data from file: '" + f + "'");
            }
            FileReader fileReader = new FileReader(f);
            BufferedReader br = new BufferedReader(fileReader);
            this.csvReader = new CSVReader((Reader)br, this.csvLoader.getCsvSeparatedBy().charAt(0), this.csvLoader.getCsvQuoteChar().charAt(0), this.csvLoader.getCsvEscapeChar().charAt(0));
            String[] header = this.csvReader.readNext();
            if (header == null) {
                throw new IOException("The CSV file has no header: '" + f + "'");
            }
            String[] firstRow = this.csvReader.readNext();
            if (firstRow == null || firstRow.length < header.length) {
                firstRow = null;
            }
            this.setPropertySize(header.length);
            for (int i = 0; i < header.length; ++i) {
                String token = header[i];
                LabelDomain domain = firstRow != null ? this.calculateDomain(firstRow[i]) : new LabelDomain();
                CSVDataProperty dp = this.createCSVProperty();
                dp.setPropertyId(token.toLowerCase());
                dp.setDomain((Domain)domain);
                this.addProperty((DataProperty)dp, i);
            }
            if (firstRow != null) {
                Object[] row = this.processLine(firstRow);
                this.addRowValues(row);
                String[] line = this.csvReader.readNext();
                while (line != null) {
                    for (int i = 0; line != null && i < 10000; ++i) {
                        row = this.processLine(line);
                        this.addRowValues(row);
                        line = this.csvReader.readNext();
                    }
                    trace.update(this);
                    trace.checkRuntimeConstraints();
                }
            }
        }
        finally {
            trace.end();
        }
    }

    protected Object[] processLine(String[] line) throws Exception {
        Object[] row = new Object[line.length];
        for (int j = 0; j < line.length; ++j) {
            String valueStr = line[j];
            CSVDataProperty prop = (CSVDataProperty)this.getProperties()[j];
            row[j] = !StringUtils.isBlank((CharSequence)valueStr) ? this.parseValue(prop, valueStr) : null;
        }
        return row;
    }

    public Domain calculateDomain(String value) {
        try {
            this._dateFormat.parse(value);
            return new DateDomain();
        }
        catch (Exception e) {
            try {
                this._numberFormat.parse(value);
                return new NumericDomain();
            }
            catch (Exception ee) {
                return new LabelDomain();
            }
        }
    }

    public Object parseValue(CSVDataProperty prop, String value) throws Exception {
        Domain domain = prop.getDomain();
        try {
            if (domain instanceof DateDomain) {
                return this._dateFormat.parse(value);
            }
            if (domain instanceof NumericDomain) {
                return new Double(this._numberFormat.parse(value).doubleValue());
            }
            return value;
        }
        catch (ParseException e) {
            String msg = "Error parsing value: " + value + ", " + e.getMessage() + ". Check column's data type consistency!";
            log.error(msg);
            throw new Exception(msg);
        }
    }

    public class CSVReadTrace
    extends CodeBlockTrace {
        protected Map<String, Object> context;

        public CSVReadTrace(CSVDataLoader dataLoader) {
            super("csv-read" + dataLoader.getFileURL());
            this.context = new HashMap<String, Object>();
            this.context.put("Description", "CSV Read - " + CSVDataSet.this.csvLoader.getFileURL());
            this.context.put("File URL", dataLoader.getFileURL());
            this.context.put("Quote char", dataLoader.getCsvQuoteChar());
            this.context.put("Separator", dataLoader.getCsvSeparatedBy());
            this.context.put("Escape char", dataLoader.getCsvEscapeChar());
            this.context.put("Date pattern", dataLoader.getCsvDatePattern());
            this.context.put("Number pattern", dataLoader.getCsvNumberPattern());
            this.context.put("Number decimal separator", Character.valueOf(dataLoader.getCsvNumberDecimalSeparator()));
            this.context.put("Number group separator", Character.valueOf(dataLoader.getCsvNumberGroupSeparator()));
        }

        public CodeBlockType getType() {
            return CoreCodeBlockTypes.CSV;
        }

        public String getDescription() {
            return (String)this.context.get("Description");
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public void update(CSVDataSet dataSet) {
            this.context.put("Data set #columns", dataSet.getProperties().length);
            this.context.put("Data set #rows", dataSet.getRowCount());
            this.context.put("Data set size", MemoryProfiler.formatSize((long)dataSet.sizeOf()));
        }
    }
}

