/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.sql;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.jboss.dashboard.export.AbstractDataLoaderXMLFormat;
import org.jboss.dashboard.provider.DataLoader;
import org.jboss.dashboard.provider.sql.SQLDataLoader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SQLDataLoaderXMLFormat
extends AbstractDataLoaderXMLFormat {
    public DataLoader parse(NodeList xmlNodes) throws Exception {
        for (int i = 0; i < xmlNodes.getLength(); ++i) {
            Node item = xmlNodes.item(i);
            if (!item.getNodeName().equals("sqlprovider")) continue;
            SQLDataLoader loader = new SQLDataLoader();
            NodeList subNodes = item.getChildNodes();
            for (int j = 0; j < subNodes.getLength(); ++j) {
                item = subNodes.item(j);
                if (item.getNodeName().equals("datasource") && item.hasChildNodes()) {
                    loader.setDataSource(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()));
                }
                if (!item.getNodeName().equals("query") || !item.hasChildNodes()) continue;
                Node typeNode = item.getAttributes().getNamedItem("type");
                String dataBaseName = "default";
                if (typeNode != null) {
                    dataBaseName = typeNode.getNodeValue().toLowerCase();
                }
                loader.setSQLQuery(StringEscapeUtils.unescapeXml((String)item.getFirstChild().getNodeValue()), dataBaseName);
            }
            return loader;
        }
        return null;
    }

    public void format(DataLoader loader, PrintWriter out, int indent) throws Exception {
        SQLDataLoader sqlLoader = (SQLDataLoader)loader;
        this.printIndent(out, indent++);
        out.println("<sqlprovider>");
        this.printIndent(out, indent);
        out.print("<datasource>");
        out.print(StringEscapeUtils.escapeXml((String)sqlLoader.getDataSource()));
        out.println("</datasource>");
        Map queryMap = sqlLoader.getQueryMap();
        if (queryMap.size() > 1) {
            for (String dataBaseName : queryMap.keySet()) {
                this.printIndent(out, indent);
                out.print("<query type=\"" + dataBaseName.toLowerCase() + "\">");
                out.print(StringEscapeUtils.escapeXml((String)sqlLoader.getSQLQuery(dataBaseName)));
                out.println("</query>");
            }
        } else if (queryMap.size() == 1) {
            String dataBaseName = (String)queryMap.keySet().iterator().next();
            out.print("<query>");
            out.print(StringEscapeUtils.escapeXml((String)sqlLoader.getSQLQuery(dataBaseName)));
            out.println("</query>");
        }
        this.printIndent(out, --indent);
        out.println("</sqlprovider>");
    }
}

