/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.provider.sql;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.DataSourceManager;
import org.jboss.dashboard.database.hibernate.HibernateInitializer;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.sql.SQLDataSet;
import org.jboss.dashboard.provider.AbstractDataLoader;
import org.jboss.dashboard.provider.DataProvider;

public class SQLDataLoader
extends AbstractDataLoader {
    private static transient Log log = LogFactory.getLog(SQLDataLoader.class);
    public static final String PARAM_DEFAULT_QUERY = "default";
    protected String dataSource;
    protected String dataBaseName = null;
    protected Map<String, String> queryMap = new HashMap<String, String>();

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    protected void setDataBaseName(String dataBaseName) {
        this.dataBaseName = dataBaseName;
    }

    public Map getQueryMap() {
        return this.queryMap;
    }

    public void setQueryMap(Map queryMap) {
        this.queryMap = queryMap;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
        try {
            if (dataSource != null) {
                HibernateInitializer hbnInitializer = CoreServices.lookup().getHibernateInitializer();
                DataSourceManager dataSourceManager = CoreServices.lookup().getDataSourceManager();
                DataSource ds = dataSourceManager.getDataSource(dataSource);
                this.dataBaseName = hbnInitializer.inferDatabaseName(ds);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot get datasource named " + dataSource), (Throwable)e);
        }
    }

    public String getSQLQuery() {
        return this.getSQLQuery(this.dataBaseName);
    }

    public String getSQLQuery(String dataBaseName) {
        String query = null;
        if (dataBaseName != null) {
            query = this.queryMap.get(dataBaseName);
        }
        if (query != null) {
            return query;
        }
        return this.queryMap.get(PARAM_DEFAULT_QUERY);
    }

    public void setSQLQuery(String SQLQuery) {
        this.setSQLQuery(SQLQuery, this.dataBaseName);
    }

    public void setSQLQuery(String query, String dataBaseName) {
        this.queryMap.put(dataBaseName, query);
    }

    public boolean isReady() {
        return this.dataSource != null && this.getSQLQuery() != null;
    }

    public DataSet load(DataProvider provider) throws Exception {
        SQLDataSet newDs = new SQLDataSet(provider, this);
        newDs.load();
        return newDs;
    }
}

