/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jboss.dashboard.DataProviderServices;
import org.jboss.dashboard.command.CommandProcessor;
import org.jboss.dashboard.command.SQLConditionCommand;
import org.jboss.dashboard.command.TemplateProcessor;

public class SQLStatement {
    protected String SQLTemplate;
    protected transient String SQLSentence;
    protected transient List SQLParameters;

    public SQLStatement(String sqlTemplate) throws Exception {
        this.SQLTemplate = sqlTemplate;
        TemplateProcessor tp = DataProviderServices.lookup().getTemplateProcessor();
        CommandProcessor cp = DataProviderServices.lookup().getCommandProcessorFactory().createCommandProcessor();
        this.SQLSentence = tp.processTemplate(this.SQLTemplate, cp);
        this.SQLParameters = new ArrayList();
        Iterator commandIt = cp.getSuccessfulCommands().iterator();
        while (commandIt.hasNext()) {
            try {
                SQLConditionCommand sqlCommand = (SQLConditionCommand)((Object)commandIt.next());
                this.SQLParameters.addAll(sqlCommand.getPreparedStatementParameters());
            }
            catch (ClassCastException e) {}
        }
    }

    public String getSQLTemplate() {
        return this.SQLTemplate;
    }

    public String getSQLSentence() {
        return this.SQLSentence;
    }

    public List getSQLParameters() {
        return Collections.unmodifiableList(this.SQLParameters);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.SQLSentence).toHashCode();
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.SQLTemplate == null) {
                return false;
            }
            SQLStatement other = (SQLStatement)obj;
            if (!this.SQLTemplate.equals(other.SQLTemplate)) {
                return false;
            }
            if (!this.SQLSentence.equals(other.SQLSentence)) {
                return false;
            }
            if (this.SQLParameters.size() != other.SQLParameters.size()) {
                return false;
            }
            for (int i = 0; i < this.SQLParameters.size(); ++i) {
                if (this.SQLParameters.get(i).equals(other.SQLParameters.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(this.SQLSentence);
        int psParamIndex = 1;
        for (Object param : this.SQLParameters) {
            if (param instanceof String) {
                preparedStatement.setString(psParamIndex, (String)param);
            } else if (param instanceof Date) {
                preparedStatement.setTimestamp(psParamIndex, new Timestamp(((Date)param).getTime()));
            } else if (param instanceof Float) {
                preparedStatement.setFloat(psParamIndex, ((Float)param).floatValue());
            } else if (param instanceof Double) {
                preparedStatement.setDouble(psParamIndex, (Double)param);
            } else if (param instanceof Number) {
                preparedStatement.setLong(psParamIndex, ((Number)param).longValue());
            } else if (param instanceof Boolean) {
                preparedStatement.setBoolean(psParamIndex, (Boolean)param);
            }
            ++psParamIndex;
        }
        return preparedStatement;
    }
}

