/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.dataset.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.jboss.dashboard.CoreServices;
import org.jboss.dashboard.database.hibernate.SQLStatementTrace;
import org.jboss.dashboard.dataset.AbstractDataSet;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.profiler.DataSetLoadConstraints;
import org.jboss.dashboard.dataset.sql.SQLStatement;
import org.jboss.dashboard.profiler.CodeBlockTrace;
import org.jboss.dashboard.profiler.RuntimeConstraint;
import org.jboss.dashboard.provider.DataFilter;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.sql.SQLDataLoader;
import org.jboss.dashboard.provider.sql.SQLDataProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDataSet
extends AbstractDataSet {
    private static transient Logger log = LoggerFactory.getLogger(SQLDataSet.class);
    protected String dataSource;
    protected String sqlQuery;
    protected transient SQLStatement lastExecutedStmt;

    public SQLDataSet(DataProvider provider, SQLDataLoader loader) {
        super(provider);
        this.dataSource = loader.getDataSource();
        this.sqlQuery = loader.getSQLQuery();
    }

    public SQLDataSet(DataProvider provider, String dataSource, String sqlQuery) {
        super(provider);
        this.dataSource = dataSource;
        this.sqlQuery = sqlQuery;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSQLQuery() {
        return this.sqlQuery;
    }

    public SQLDataProperty createSQLProperty() {
        return new SQLDataProperty();
    }

    public SQLStatement createSQLStatament() throws Exception {
        return new SQLStatement(this.sqlQuery);
    }

    public void load() throws Exception {
        DataSource targetDS = CoreServices.lookup().getDataSourceManager().getDataSource(this.dataSource);
        if (targetDS == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        CodeBlockTrace trace = null;
        try {
            conn = targetDS.getConnection();
            this.lastExecutedStmt = this.createSQLStatament();
            trace = new SQLStatementTrace(this.lastExecutedStmt.getSQLSentence()).begin();
            trace.addRuntimeConstraint((RuntimeConstraint)new DataSetLoadConstraints((DataSet)this));
            log.debug("Load data set from datasource=" + this.dataSource + " SQL=" + this.lastExecutedStmt.getSQLSentence());
            stmt = this.lastExecutedStmt.getPreparedStatement(conn);
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int propsSize = meta.getColumnCount();
            this.setPropertySize(propsSize);
            for (int i = 0; i < propsSize; ++i) {
                SQLDataProperty dp = this.createSQLProperty();
                String propId = StringUtils.isNotBlank((String)meta.getColumnLabel(i + 1)) ? meta.getColumnLabel(i + 1) : meta.getColumnName(i + 1);
                dp.setPropertyId(propId.toLowerCase());
                dp.setType(meta.getColumnType(i + 1));
                dp.setTableName(meta.getTableName(i + 1));
                dp.setColumnName(meta.getColumnName(i + 1));
                this.addProperty((DataProperty)dp, i);
            }
            int index = 0;
            while (rs.next()) {
                Object[] row = new Object[propsSize];
                for (int i = 0; i < propsSize; ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                this.addRowValues(row);
                if (++index != 10000) continue;
                trace.checkRuntimeConstraints();
                index = 0;
            }
            for (int i = 0; i < this.properties.length; ++i) {
                SQLDataProperty property = (SQLDataProperty)this.properties[i];
                property.calculateDomain();
            }
        }
        catch (Exception e) {
            if (this.lastExecutedStmt != null) {
                log.error("Error in load() SQLDataset. SQL = " + this.lastExecutedStmt.getSQLSentence(), (Throwable)e);
            }
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                log.warn("Error closing ResultSet: ", (Throwable)e);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Error closing PreparedStatement: ", (Throwable)e);
            }
            if (conn != null) {
                conn.close();
            }
            if (trace != null) {
                trace.end();
            }
        }
    }

    public DataSet filter(DataFilter filter) throws Exception {
        return this._filterInDB(filter);
    }

    public DataSet _filterInDB(DataFilter filter) throws Exception {
        SQLStatement currentStatement = this.createSQLStatament();
        if (!this.lastExecutedStmt.equals(currentStatement)) {
            SQLDataSet sqlDataSet = new SQLDataSet(this.provider, this.dataSource, this.sqlQuery);
            sqlDataSet.load();
            DataFilter _remainingFilter = (DataFilter)filter.cloneFilter();
            List<String> propIds = currentStatement.getFilterPropertyIds();
            for (String propId : propIds) {
                _remainingFilter.removeProperty(propId);
            }
            DataSet result = sqlDataSet._filterInMemory(_remainingFilter);
            if (result != null) {
                return result;
            }
            return sqlDataSet;
        }
        return super._filterInMemory(filter);
    }
}

