/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.displayer;

import java.io.InputStream;
import java.util.Comparator;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.dashboard.DataProviderServices;
import org.jboss.dashboard.commons.cdi.CDIBeanLocator;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.dataset.DataSetComparator;
import org.jboss.dashboard.dataset.DataSetManager;
import org.jboss.dashboard.displayer.DataDisplayerManager;
import org.jboss.dashboard.displayer.chart.BarChartDisplayer;
import org.jboss.dashboard.displayer.chart.BarChartDisplayerType;
import org.jboss.dashboard.function.ScalarFunction;
import org.jboss.dashboard.function.ScalarFunctionManager;
import org.jboss.dashboard.provider.DataLoader;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataProvider;
import org.jboss.dashboard.provider.DataProviderManager;
import org.jboss.dashboard.provider.DataProviderType;
import org.jboss.dashboard.provider.csv.CSVDataLoader;
import org.jboss.dashboard.test.ShrinkWrapHelper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class BarChartDisplayerCSVTest {
    @Inject
    protected BeanManager beanManager;
    @Inject
    protected DataProviderManager dataProviderManager;
    @Inject
    protected ScalarFunctionManager scalarFunctionManager;
    @Inject
    protected DataDisplayerManager dataDisplayerManager;
    protected DataSetManager dataSetManager;
    protected DataSet dataSet;
    protected DataProviderType dataPoviderType;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        CDIBeanLocator.beanManager = this.beanManager;
        this.dataSetManager = DataProviderServices.lookup().getDataSetManager();
        this.dataPoviderType = this.dataProviderManager.getProviderTypeByUid("csv");
        DataProvider dataProvider = this.dataProviderManager.createDataProvider();
        CSVDataLoader csvDataLoader = (CSVDataLoader)this.dataPoviderType.createDataLoader();
        dataProvider.setDataLoader((DataLoader)csvDataLoader);
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("data.csv");
        this.dataSet = csvDataLoader.load(dataProvider, dataStream);
        this.dataSetManager.registerDataSet(dataProvider, this.dataSet);
    }

    @Test
    public void buildDataSet() {
        Assertions.assertThat((Object)this.dataSet).isNotNull();
        DataProperty propDept = this.dataSet.getPropertyById("department");
        DataProperty propAmount = this.dataSet.getPropertyById("amount");
        Assertions.assertThat((Object)propDept).isNotNull();
        Assertions.assertThat((Object)propAmount).isNotNull();
        BarChartDisplayerType barChartDisplayerType = (BarChartDisplayerType)this.dataDisplayerManager.getDisplayerTypeByUid("barchart");
        BarChartDisplayer barChartDisplayer = (BarChartDisplayer)barChartDisplayerType.createDataDisplayer();
        barChartDisplayer.setDataProvider(this.dataSet.getDataProvider());
        barChartDisplayer.setDomainProperty(propDept);
        barChartDisplayer.setRangeProperty(propAmount);
        ScalarFunction scalarFunction = this.scalarFunctionManager.getScalarFunctionByCode("sum");
        barChartDisplayer.setRangeScalarFunction(scalarFunction);
        DataSet xyDataSet = barChartDisplayer.buildXYDataSet();
        org.jboss.dashboard.dataset.Assertions.assertDataSetValues((DataSet)xyDataSet, (String[][])new String[][]{{"Engineering", "7,650.162"}, {"Services", "2,504.5"}, {"Sales", "3,213.53"}, {"Support", "3,345.6"}, {"Management", "6,017.47"}}, (int)0);
        DataSetComparator comp = new DataSetComparator();
        comp.addSortCriteria("0", -1);
        xyDataSet = xyDataSet.sort((Comparator)comp);
        org.jboss.dashboard.dataset.Assertions.assertDataSetValues((DataSet)xyDataSet, (String[][])new String[][]{{"Support", "3,345.6"}}, (int)0);
        comp = new DataSetComparator();
        comp.addSortCriteria("1", 1);
        xyDataSet = xyDataSet.sort((Comparator)comp);
        org.jboss.dashboard.dataset.Assertions.assertDataSetValues((DataSet)xyDataSet, (String[][])new String[][]{{"Services", "2,504.5"}}, (int)0);
    }
}

