/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dashboard.test;

import java.util.Locale;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.dashboard.dataset.DataSet;
import org.jboss.dashboard.kpi.KPI;
import org.jboss.dashboard.provider.DataFormatterRegistry;
import org.jboss.dashboard.provider.DataProperty;
import org.jboss.dashboard.provider.DataPropertyFormatter;
import org.jboss.dashboard.test.KPIHelper;

public class KPITestMethodGenerator {
    public static final String TEST_KPI_METHOD_TEMPLATE = "    @Test // Auto-generated by KPITestMethodGenerator\n    public void test_{kpiCode}() throws Exception {\n        KPI kpi = getKPIByCode(\"{kpiCode}\");\n        DataSet dataSet = KPIHelper.getDataSet(kpi);\n        if  (dataSet != null) {\n            assertDataSetValues(dataSet, {kpiValues}, 0);\n        }\n    }\n";

    public static String generateKPITestMethod(KPI kpi) {
        String kpiCode = kpi.getCode();
        String kpiArray = KPITestMethodGenerator.generateKPIValuesArray(kpi);
        String methodStr = StringUtils.replace((String)TEST_KPI_METHOD_TEMPLATE, (String)"{kpiCode}", (String)kpiCode);
        methodStr = StringUtils.replace((String)methodStr, (String)"{kpiValues}", (String)kpiArray);
        return methodStr;
    }

    public static String generateKPIValuesArray(KPI kpi) {
        DataSet dataSet = KPIHelper.getDataSet(kpi);
        if (dataSet == null) {
            return null;
        }
        DataFormatterRegistry dataFormatterRegistry = DataFormatterRegistry.lookup();
        StringBuffer buf = new StringBuffer();
        buf.append("new String[][] {");
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            buf.append("\n{");
            for (int j = 0; j < dataSet.getProperties().length; ++j) {
                Object dataSetValue = dataSet.getValueAt(i, j);
                DataProperty prop = dataSet.getPropertyByColumn(j);
                DataPropertyFormatter propFormatter = dataFormatterRegistry.getPropertyFormatter(prop.getPropertyId());
                String displayedValue = propFormatter.formatValue(prop, dataSetValue, Locale.ENGLISH);
                if (j > 0) {
                    buf.append(",");
                }
                buf.append("\"" + displayedValue + "\"");
            }
            buf.append("}");
            if (i >= dataSet.getRowCount() - 1) continue;
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }
}

