/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentDeployer<D, C>
extends AbstractRealDeployerWithInput<D> {
    private DeploymentVisitor<C> compVisitor;

    public AbstractComponentDeployer() {
        this.setAllInputs(true);
    }

    public Class<? extends C> getOutput() {
        Class<?> output = super.getOutput();
        if (output == null) {
            throw new IllegalStateException("No output for " + this);
        }
        return output;
    }

    protected void setComponentVisitor(DeploymentVisitor<C> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.compVisitor = visitor;
        Class<C> componentType = visitor.getVisitorType();
        if (componentType == null) {
            throw new IllegalArgumentException("Null visitor type");
        }
        this.setOutput(componentType);
        this.addInput(componentType);
    }

    @Override
    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        super.internalDeploy(unit);
        try {
            this.deployComponents(unit);
        }
        catch (Throwable t) {
            this.undeployComponents(unit);
            throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + unit.getName()), (Throwable)t);
        }
    }

    @Override
    public void internalUndeploy(DeploymentUnit unit) {
        super.internalUndeploy(unit);
        this.undeployComponents(unit);
    }

    protected void deployComponents(DeploymentUnit unit) throws DeploymentException {
        if (this.compVisitor == null) {
            return;
        }
        Set components = unit.getAllMetaData(this.getOutput());
        for (Object component : components) {
            this.compVisitor.deploy(unit, component);
        }
    }

    protected void undeployComponents(DeploymentUnit unit) {
        if (this.compVisitor == null) {
            return;
        }
        Set components = unit.getAllMetaData(this.getOutput());
        for (Object component : components) {
            this.compVisitor.undeploy(unit, component);
        }
    }
}

