/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public abstract class AbstractClassLoaderDeployer
extends AbstractDeployer
implements ClassLoaderFactory {
    public AbstractClassLoaderDeployer() {
        this.setStage(DeploymentStages.CLASSLOADER);
        this.setInput(ClassLoaderFactory.class);
        this.setOutput(ClassLoader.class);
        this.setAllInputs(true);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        ClassLoaderFactory factory = (ClassLoaderFactory)unit.getAttachment(ClassLoaderFactory.class);
        if (factory == null) {
            factory = this;
        }
        unit.createClassLoader(factory);
    }

    public void undeploy(DeploymentUnit unit) {
        ClassLoaderFactory factory = (ClassLoaderFactory)unit.getAttachment(ClassLoaderFactory.class);
        if (factory == null) {
            factory = this;
        }
        unit.removeClassLoader(factory);
    }

    public void removeClassLoader(DeploymentUnit unit) throws Exception {
    }
}

