/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.deployer;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.structure.spi.DeploymentContext;

/**
 * Deployers Change Extensions.
 * 
 * @author <a href="adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public interface DeployersChangeExt
{
   /**
    * Change the state of a number of deployments and check the changes are complete
    * 
    * @param stage the stage
    * @param checkComplete whether to check the deployments are complete
    * @param contexts the deployment contexts
    * @throws DeploymentException for any error
    */
   void change(DeploymentStage stage, boolean checkComplete, DeploymentContext... contexts) throws DeploymentException;

   /**
    * Change the state of a number of deployments to the given stage,
    * then return them to their original stage and optionally check the changes are complete.<p>
    * 
    * NOTE: This only moves things backwards.
    * 
    * @param stage the stage
    * @param checkComplete whether to check the deployments are complete
    * @param contexts the deployment contexts
    * @throws DeploymentException for any error
    */
   void bounce(DeploymentStage stage, boolean checkComplete, DeploymentContext... contexts) throws DeploymentException;
}
