/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import org.jboss.deployers.spi.deployer.helpers.AbstractAttachmentLocatorType;
import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
import org.jboss.deployers.spi.deployer.helpers.AttachmentLocatorType;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AttachmentLocatorEnum implements AttachmentLocatorType
{
    LOCAL(new LocalAttachmentLocatorType()),
    PARENT(new ParentAttachmentLocatorType()),
    TOP(new TopAttachmentLocatorType()),
    HIERARCHY(new HierarchyAttachmentLocatorType());

    private AttachmentLocatorType type;

    private AttachmentLocatorEnum(AttachmentLocatorType type) {
        this.type = type;
    }

    @Override
    public <T> T search(DeploymentUnit unit, Class<T> expectedType) {
        return this.search(unit, AbstractAttachmentLocatorType.checkExpectedType(expectedType), expectedType);
    }

    @Override
    public <T> T search(DeploymentUnit unit, String name, Class<T> expectedType) {
        return this.type.search(unit, name, expectedType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HierarchyAttachmentLocatorType
    extends AbstractAttachmentLocatorType {
        @Override
        public <T> T search(DeploymentUnit unit, String name, Class<T> expectedType) {
            return AttachmentLocator.searchAncestors(unit, name, expectedType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopAttachmentLocatorType
    extends AbstractAttachmentLocatorType {
        @Override
        public <T> T search(DeploymentUnit unit, String name, Class<T> expectedType) {
            return (T)unit.getTopLevel().getAttachment(name, expectedType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParentAttachmentLocatorType
    extends AbstractAttachmentLocatorType {
        @Override
        public <T> T search(DeploymentUnit unit, String name, Class<T> expectedType) {
            DeploymentUnit parent = unit.getParent();
            return (T)(parent != null ? parent.getAttachment(name, expectedType) : null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocalAttachmentLocatorType
    extends AbstractAttachmentLocatorType {
        @Override
        public <T> T search(DeploymentUnit unit, String name, Class<T> expectedType) {
            return (T)unit.getAttachment(name, expectedType);
        }
    }
}

