/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.io.IOException;
import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UrlIntegrationDeployer<T>
extends AbstractSimpleVFSRealDeployer<T> {
    private URL integrationURL;

    public UrlIntegrationDeployer(Class<T> input) {
        super(input);
        this.setStage(DeploymentStages.POST_PARSE);
    }

    public URL getIntegarionURL() {
        return this.integrationURL;
    }

    public void setIntegrationURL(URL url) {
        this.integrationURL = url;
    }

    public void deploy(VFSDeploymentUnit unit, T metaData) throws DeploymentException {
        if (this.isIntegrationDeployment(unit)) {
            try {
                VirtualFile integration = VFS.getRoot((URL)this.integrationURL);
                unit.addClassPath(new VirtualFile[]{integration});
            }
            catch (IOException e) {
                throw DeploymentException.rethrowAsDeploymentException((String)"Error adding integration path.", (Throwable)e);
            }
        }
    }

    protected abstract boolean isIntegrationDeployment(VFSDeploymentUnit var1);
}

