/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UrlIntegrationDeployer<T>
extends AbstractOptionalVFSRealDeployer<T> {
    private Set<URL> integrationURLs;

    public UrlIntegrationDeployer(Class<T> input) {
        super(input);
        this.setStage(DeploymentStages.DESCRIBE);
        this.setOutput(ClassLoadingMetaData.class);
    }

    public URL getIntegrationURL() {
        if (this.integrationURLs == null || this.integrationURLs.isEmpty()) {
            return null;
        }
        if (this.integrationURLs.size() == 1) {
            return this.integrationURLs.iterator().next();
        }
        throw new IllegalArgumentException("Multiple integration urls: " + this.integrationURLs);
    }

    public void setIntegrationURL(URL url) {
        this.integrationURLs = Collections.singleton(url);
    }

    public Set<URL> getIntegrationURLs() {
        return this.integrationURLs;
    }

    public void setIntegrationURLs(Set<URL> integrationURLs) {
        this.integrationURLs = integrationURLs;
    }

    public void start() {
        if (this.integrationURLs == null || this.integrationURLs.isEmpty()) {
            throw new IllegalArgumentException("No integration urls.");
        }
    }

    public void deploy(VFSDeploymentUnit unit, T metaData) throws DeploymentException {
        if (this.isIntegrationDeployment(unit, metaData)) {
            ArrayList<VirtualFile> added = new ArrayList<VirtualFile>();
            try {
                for (URL integrationURL : this.integrationURLs) {
                    VirtualFile integration = VFS.getRoot((URL)integrationURL);
                    unit.addClassPath(new VirtualFile[]{integration});
                    added.add(integration);
                }
            }
            catch (Throwable t) {
                List classPath = unit.getClassPath();
                for (int i = added.size() - 1; i >= 0; --i) {
                    classPath.remove(added.get(i));
                }
                throw DeploymentException.rethrowAsDeploymentException((String)"Error adding integration path.", (Throwable)t);
            }
        }
    }

    public void undeploy(VFSDeploymentUnit unit, T metaData) {
        if (this.isIntegrationDeployment(unit, metaData)) {
            List classPath = unit.getClassPath();
            for (URL integrationURL : this.integrationURLs) {
                try {
                    VirtualFile integration = VFS.getRoot((URL)integrationURL);
                    classPath.remove(integration);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error removing integration from classpath: " + integrationURL), t);
                }
            }
        }
    }

    protected String getDeployerLocation() {
        ProtectionDomain pd = ((Object)((Object)this)).getClass().getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL location = cs.getLocation();
        return location.toExternalForm();
    }

    protected boolean isIntegrationDeployment(VFSDeploymentUnit unit, T metaData) {
        return this.isIntegrationDeployment(unit);
    }

    protected abstract boolean isIntegrationDeployment(VFSDeploymentUnit var1);
}

