/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.annotations;

import java.net.URL;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.ScanningMetaData;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.plugins.util.ClasspathUtils;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnitFilter;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.repository.AbstractConfiguration;
import org.jboss.mcann.repository.AbstractSettings;
import org.jboss.mcann.repository.Configuration;
import org.jboss.mcann.repository.DefaultConfiguration;
import org.jboss.mcann.repository.Settings;
import org.jboss.mcann.scanner.DefaultAnnotationScanner;
import org.jboss.mcann.scanner.ModuleAnnotationScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationRepositoryDeployer
extends AbstractOptionalVFSRealDeployer<Module> {
    private Configuration configuration;
    private VFSDeploymentUnitFilter filter;

    public AnnotationRepositoryDeployer() {
        super(Module.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(ScanningMetaData.class);
        this.addInput(AnnotationRepository.class);
        this.setOutput(AnnotationRepository.class);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setFilter(VFSDeploymentUnitFilter filter) {
        this.filter = filter;
    }

    protected void visitModule(VFSDeploymentUnit unit, Module module) throws DeploymentException {
        try {
            URL[] urls = ClasspathUtils.getUrls(unit);
            ModuleAnnotationScanner scanner = new ModuleAnnotationScanner(module);
            DefaultConfiguration config = new DefaultConfiguration();
            this.configureScanner(unit, (DefaultAnnotationScanner)scanner, (AbstractSettings)config);
            if (this.configuration != null) {
                config.merge((Settings)this.configuration);
            }
            scanner.setConfiguration((Configuration)config);
            AnnotationRepository repository = scanner.scan(unit.getClassLoader(), urls);
            unit.addAttachment(AnnotationRepository.class, (Object)repository);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Exception visiting module", (Throwable)e);
        }
    }

    protected AbstractConfiguration createConfiguration(VFSDeploymentUnit unit) {
        return new DefaultConfiguration();
    }

    protected void configureScanner(VFSDeploymentUnit unit, DefaultAnnotationScanner scanner, AbstractSettings settings) {
    }

    public void deploy(VFSDeploymentUnit unit, Module module) throws DeploymentException {
        if (unit.isAttachmentPresent(AnnotationRepository.class)) {
            return;
        }
        if (this.filter != null && !this.filter.accepts(unit)) {
            return;
        }
        if (module == null) {
            for (VFSDeploymentUnit parent = unit.getParent(); parent != null && module == null; parent = parent.getParent()) {
                module = (Module)parent.getAttachment(Module.class);
            }
            if (module == null) {
                throw new IllegalArgumentException("No module in deployment unit's hierarchy: " + unit.getName());
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating AnnotationRepository for " + unit.getName() + ", module: " + module + ", configuration: " + this.configuration));
        }
        this.visitModule(unit, module);
    }
}

