/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javassist.ClassPath;
import javassist.NotFoundException;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.collection.SoftValueHashMap;
import org.jboss.vfs.VirtualFile;

public class DeploymentUnitClassPath
implements ClassPath {
    private VFSDeploymentUnit unit;
    private Map<String, VirtualFile> cache = Collections.synchronizedMap(new SoftValueHashMap());
    private ClassFilter excludeFilter = ClassFilterUtils.JAVA_ONLY;

    public DeploymentUnitClassPath(VFSDeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit.");
        }
        this.unit = unit;
    }

    public void setExcludeFilter(ClassFilter excludeFilter) {
        this.excludeFilter = excludeFilter;
    }

    protected VirtualFile findFile(String className) throws IOException {
        if (this.excludeFilter != null && this.excludeFilter.matchesClassName(className)) {
            return null;
        }
        VirtualFile file = this.cache.get(className);
        if (file != null) {
            return file;
        }
        List classPath = this.unit.getClassPath();
        if (classPath != null && !classPath.isEmpty()) {
            String path = ClassLoaderUtils.classNameToPath((String)className);
            for (VirtualFile cp : classPath) {
                file = cp.getChild(path);
                if (!file.exists()) continue;
                this.cache.put(className, file);
                return file;
            }
        }
        return null;
    }

    public InputStream openClassfile(String className) throws NotFoundException {
        try {
            VirtualFile file = this.findFile(className);
            if (file != null) {
                return file.openStream();
            }
        }
        catch (IOException e) {
            throw new NotFoundException("Exception finding file: " + className, (Exception)e);
        }
        throw new NotFoundException("ClassName '" + className + "' not found in deployment unit: " + this.unit);
    }

    public URL find(String className) {
        try {
            VirtualFile file = this.findFile(className);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void close() {
        this.cache.clear();
    }
}

