/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.explicit;

import java.io.IOException;
import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.plugins.structure.explicit.StructureMetaDataObjectFactory;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.vfs.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class DeclaredStructure
extends AbstractVFSStructureDeployer {
    public DeclaredStructure() {
        this.setRelativeOrder(0);
    }

    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        block8: {
            VirtualFile file = structureContext.getFile();
            try {
                boolean trace = log.isTraceEnabled();
                if (DeclaredStructure.isLeaf((VirtualFile)file)) break block8;
                boolean isJBossStructure = false;
                if (trace) {
                    log.trace((Object)(file + " is not a leaf"));
                }
                try {
                    VirtualFile jbossStructure = file.getChild("META-INF/jboss-structure.xml");
                    if (jbossStructure.exists()) {
                        if (trace) {
                            log.trace((Object)"... context has a META-INF/jboss-structure.xml");
                        }
                        URL url = jbossStructure.toURL();
                        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
                        Unmarshaller unmarshaller = factory.newUnmarshaller();
                        StructureMetaDataObjectFactory ofactory = new StructureMetaDataObjectFactory();
                        unmarshaller.unmarshal(url.toString(), (ObjectModelFactory)ofactory, (Object)structureContext.getMetaData());
                        isJBossStructure = true;
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Exception while looking for META-INF/jboss-structure.xml: " + e));
                }
                if (trace) {
                    log.trace((Object)(file + " isJBossStructure: " + isJBossStructure));
                }
                return isJBossStructure;
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
            }
        }
        return false;
    }
}

