/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.war;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataType;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSArchiveStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;

public class WARStructure
extends AbstractVFSArchiveStructureDeployer {
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private VirtualFileFilter webInfLibFilter = DEFAULT_WEB_INF_LIB_FILTER;
    private VirtualFileFilter webInfLibMetaDataFilter;
    private boolean includeWebInfInClasspath;

    public WARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getWebInfLibFilter() {
        return this.webInfLibFilter;
    }

    public void setWebInfLibFilter(VirtualFileFilter webInfLibFilter) {
        if (webInfLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.webInfLibFilter = webInfLibFilter;
    }

    public VirtualFileFilter getWebInfLibMetaDataFilter() {
        return this.webInfLibMetaDataFilter;
    }

    public void setWebInfLibMetaDataFilter(VirtualFileFilter webInfLibMetaDataFilter) {
        this.webInfLibMetaDataFilter = webInfLibMetaDataFilter;
    }

    public void setIncludeWebInfInClasspath(boolean includeWebInfInClasspath) {
        this.includeWebInfInClasspath = includeWebInfInClasspath;
    }

    protected boolean hasValidSuffix(String name) {
        return name.endsWith(".war");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doDetermineStructure(StructureContext structureContext) throws DeploymentException {
        ContextInfo context = null;
        VirtualFile file = structureContext.getFile();
        try {
            VirtualFile webinf;
            boolean trace;
            block22: {
                block21: {
                    trace = log.isTraceEnabled();
                    webinf = null;
                    if (this.hasValidSuffix(file.getName())) break block21;
                    webinf = file.getChild("WEB-INF");
                    if (webinf.exists()) {
                        if (trace) {
                            log.trace((Object)"... ok - directory has a WEB-INF subdirectory");
                        }
                        break block22;
                    } else {
                        if (trace) {
                            log.trace((Object)"... no - doesn't look like a war and no WEB-INF subdirectory.");
                        }
                        return false;
                    }
                }
                if (trace) {
                    log.trace((Object)"... ok - name ends in .war.");
                }
            }
            ArrayList<String> metaDataLocations = new ArrayList<String>();
            metaDataLocations.add("WEB-INF");
            VirtualFile classes = file.getChild("WEB-INF/classes");
            if (classes.exists()) {
                metaDataLocations.add("WEB-INF/classes/META-INF");
            }
            context = this.createContext(structureContext, metaDataLocations.toArray(new String[metaDataLocations.size()]));
            List archives = null;
            try {
                VirtualFile webinfLib = file.getChild("WEB-INF/lib");
                if (webinfLib.exists()) {
                    archives = webinfLib.getChildren(this.webInfLibFilter);
                    for (VirtualFile jar : archives) {
                        if (this.webInfLibMetaDataFilter != null && this.webInfLibMetaDataFilter != this.webInfLibFilter && !this.webInfLibMetaDataFilter.accepts(jar)) continue;
                        this.addMetaDataPath(structureContext, context, "WEB-INF/lib/" + jar.getName() + "/META-INF", MetaDataType.ALTERNATIVE);
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)("Exception looking for WEB-INF/lib, " + file.getPathName() + ", " + e));
            }
            this.addClassPath(structureContext, file, false, true, context);
            if (classes != null) {
                this.addClassPath(structureContext, classes, true, false, context);
            } else if (trace) {
                log.trace((Object)("No WEB-INF/classes for: " + file.getPathName()));
            }
            if (archives != null) {
                for (VirtualFile jar : archives) {
                    Automounter.mount((VirtualFile)file, (VirtualFile)jar, (MountOption[])new MountOption[0]);
                    this.addClassPath(structureContext, jar, true, true, context);
                }
            } else if (trace) {
                log.trace((Object)("No WEB-INF/lib for: " + file.getPathName()));
            }
            if (this.includeWebInfInClasspath && webinf != null) {
                this.addClassPath(structureContext, webinf, true, false, context);
            }
            return true;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }
}

