/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.jar;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.metadata.api.annotations.Install;
import org.jboss.beans.metadata.api.annotations.Uninstall;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.matchers.JarExtensionProvider;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSArchiveStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JARStructure
extends AbstractVFSArchiveStructureDeployer {
    private final Set<String> suffixes = Collections.synchronizedSet(new HashSet());
    public static Set<String> DEFAULT_JAR_SUFFIXES = new HashSet<String>();

    public JARStructure() {
        this(DEFAULT_JAR_SUFFIXES);
    }

    public JARStructure(Set<String> suffixes) {
        if (suffixes != null) {
            this.setSuffixes(suffixes);
        }
        this.setRelativeOrder(10000);
    }

    public Set<String> getSuffixes() {
        return this.suffixes;
    }

    public void setSuffixes(Set<String> suffixes) {
        this.suffixes.retainAll(suffixes);
        this.suffixes.addAll(suffixes);
    }

    @Install
    public void addJarExtension(JarExtensionProvider provider) {
        String extension = provider.getJarExtension();
        if (extension != null) {
            this.suffixes.add(extension);
        }
    }

    @Uninstall
    public void removeJarExtension(JarExtensionProvider provider) {
        String extension = provider.getJarExtension();
        if (extension != null) {
            this.suffixes.remove(extension);
        }
    }

    @Override
    protected boolean hasValidSuffix(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return false;
        }
        return this.suffixes.contains(name.substring(idx).toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doDetermineStructure(StructureContext structureContext) throws DeploymentException {
        ContextInfo context = null;
        VirtualFile file = structureContext.getFile();
        try {
            StructureContext parentContext;
            boolean trace;
            block12: {
                block13: {
                    trace = log.isTraceEnabled();
                    if (this.hasValidSuffix(file.getName())) break block12;
                    if (structureContext.isTopLevel()) break block13;
                    VirtualFile child = file.getChild("META-INF");
                    if (child.exists()) {
                        if (trace) {
                            log.trace((Object)"... ok - non top level directory has a META-INF subdirectory");
                        }
                        break block12;
                    } else {
                        if (trace) {
                            log.trace((Object)"... no - doesn't look like a jar and no META-INF subdirectory.");
                        }
                        return false;
                    }
                }
                if (trace) {
                    log.trace((Object)"... ok - doesn't look like a jar but it is a top level directory.");
                }
            }
            if (trace) {
                log.trace((Object)"... ok - its an archive or at least pretending to be");
            }
            boolean valid = true;
            if (this.isSupportsCandidateAnnotations() && (parentContext = structureContext.getParentContext()) != null && parentContext.isCandidateAnnotationScanning()) {
                valid = this.checkCandidateAnnotations(structureContext, new VirtualFile[]{file});
                if (trace) {
                    log.trace((Object)("... candidate annotations for " + file + " returned " + valid));
                }
            }
            if (valid) {
                context = this.createContext(structureContext, "META-INF");
                this.addClassPath(structureContext, file, true, true, context);
                this.addAllChildren(structureContext);
            }
            return valid;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }

    static {
        DEFAULT_JAR_SUFFIXES = new HashSet<String>();
        DEFAULT_JAR_SUFFIXES.add(".zip");
        DEFAULT_JAR_SUFFIXES.add(".ear");
        DEFAULT_JAR_SUFFIXES.add(".jar");
        DEFAULT_JAR_SUFFIXES.add(".rar");
        DEFAULT_JAR_SUFFIXES.add(".war");
        DEFAULT_JAR_SUFFIXES.add(".sar");
        DEFAULT_JAR_SUFFIXES.add(".har");
        DEFAULT_JAR_SUFFIXES.add(".aop");
    }
}

