/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.types.TableMetaType;
import org.jboss.metatype.api.values.ArrayValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMetaType
extends AbstractMetaType {
    private static final long serialVersionUID = -2062790692152055156L;
    private int dimension = 0;
    private MetaType elementType;
    private boolean primitiveArray;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    private transient String cachedToString = null;
    private static final int PRIMITIVE_WRAPPER_NAME_INDEX = 0;
    private static final int PRIMITIVE_TYPE_NAME_INDEX = 1;
    private static final int PRIMITIVE_TYPE_ENCODING_INDEX = 2;
    private static final int PRIMITIVE_OPEN_TYPE_INDEX = 3;
    private static final Object[][] PRIMITIVE_ARRAY_TYPES = new Object[][]{{Boolean.class.getName(), Boolean.TYPE.getName(), "Z", SimpleMetaType.BOOLEAN}, {Character.class.getName(), Character.TYPE.getName(), "C", SimpleMetaType.CHARACTER}, {Byte.class.getName(), Byte.TYPE.getName(), "B", SimpleMetaType.BYTE}, {Short.class.getName(), Short.TYPE.getName(), "S", SimpleMetaType.SHORT}, {Integer.class.getName(), Integer.TYPE.getName(), "I", SimpleMetaType.INTEGER}, {Long.class.getName(), Long.TYPE.getName(), "J", SimpleMetaType.LONG}, {Float.class.getName(), Float.TYPE.getName(), "F", SimpleMetaType.FLOAT}, {Double.class.getName(), Double.TYPE.getName(), "D", SimpleMetaType.DOUBLE}};

    public static boolean isPrimitiveEncoding(String primitiveKey) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!typeDescr[2].equals(primitiveKey)) continue;
            return true;
        }
        return false;
    }

    public static SimpleMetaType getPrimitiveMetaType(String primitiveTypeName) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!primitiveTypeName.equals(typeDescr[1])) continue;
            return (SimpleMetaType)typeDescr[3];
        }
        return null;
    }

    public static String getPrimitiveEncoding(String typeName) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!typeName.equals(typeDescr[0])) continue;
            return (String)typeDescr[2];
        }
        return null;
    }

    public static String getPrimitiveName(String typeName) {
        for (Object[] typeDescr : PRIMITIVE_ARRAY_TYPES) {
            if (!typeName.equals(typeDescr[0])) continue;
            return (String)typeDescr[1];
        }
        return null;
    }

    public static ArrayMetaType getArrayType(MetaType elementType) {
        return new ArrayMetaType(1, elementType);
    }

    public static ArrayMetaType getPrimitiveArrayType(Class<?> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("arrayClass must be an array");
        }
        int n = 1;
        Class<?> componentType = arrayClass.getComponentType();
        while (componentType.isArray()) {
            ++n;
            componentType = componentType.getComponentType();
        }
        String componentTypeName = componentType.getName();
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException("component type of the array must be a primitive type");
        }
        SimpleMetaType simpleType = ArrayMetaType.getPrimitiveMetaType(componentTypeName);
        ArrayMetaType at = new ArrayMetaType(simpleType, true);
        if (n > 1) {
            at = new ArrayMetaType(n - 1, at);
        }
        return at;
    }

    private static String genName(int dimension, MetaType elementType, boolean isPrimitive) {
        if (dimension < 1) {
            throw new IllegalArgumentException("negative dimension");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("null element type");
        }
        if (elementType instanceof ArrayMetaType) {
            throw new IllegalArgumentException("array type cannot be an element of an array type");
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            buffer.append('[');
        }
        if (isPrimitive) {
            buffer.append(ArrayMetaType.getPrimitiveEncoding(elementType.getClassName()));
        } else {
            buffer.append('L');
            buffer.append(elementType.getClassName());
            buffer.append(';');
        }
        return buffer.toString();
    }

    private static String genType(int dimension, MetaType elementType, boolean isPrimitive) {
        if (dimension < 1) {
            throw new IllegalArgumentException("negative dimension");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("null element type");
        }
        if (elementType instanceof ArrayMetaType) {
            throw new IllegalArgumentException("array type cannot be an element of an array type");
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            buffer.append('[');
        }
        if (isPrimitive) {
            buffer.append(ArrayMetaType.getPrimitiveEncoding(elementType.getClassName()));
        } else {
            buffer.append('L');
            buffer.append(elementType.getClassName());
            buffer.append(';');
        }
        return buffer.toString();
    }

    private static String genDesc(int dimension, MetaType elementType, boolean isPrimitive) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Integer(dimension));
        buffer.append("-dimension array of ");
        if (isPrimitive) {
            buffer.append(ArrayMetaType.getPrimitiveName(elementType.getTypeName()));
        } else {
            buffer.append(elementType.getTypeName());
        }
        return buffer.toString();
    }

    public ArrayMetaType(int dimension, MetaType elementType) {
        super(ArrayMetaType.genName(dimension, elementType, false), ArrayMetaType.genType(dimension, elementType, false), ArrayMetaType.genDesc(dimension, elementType, false));
        this.dimension = dimension;
        this.elementType = elementType;
        this.primitiveArray = false;
    }

    public ArrayMetaType(SimpleMetaType elementType, boolean primitiveArray) {
        this(1, elementType, primitiveArray);
    }

    public ArrayMetaType(int dimension, MetaType elementType, boolean primitiveArray) {
        super(ArrayMetaType.genName(dimension, elementType, primitiveArray), ArrayMetaType.genType(dimension, elementType, primitiveArray), ArrayMetaType.genDesc(dimension, elementType, primitiveArray));
        this.dimension = dimension;
        this.elementType = elementType;
        this.primitiveArray = primitiveArray;
    }

    public int getDimension() {
        return this.dimension;
    }

    public MetaType getElementType() {
        return this.elementType;
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (!clazz.isArray() && !(obj instanceof ArrayValue)) {
            return false;
        }
        if (this.elementType instanceof SimpleMetaType) {
            return this.recursiveCheck((Object[])obj, this.dimension);
        }
        if (this.elementType instanceof TableMetaType || this.elementType instanceof CompositeMetaType) {
            Class<?> thisClass;
            if (obj instanceof ArrayValue) {
                ArrayValue av = (ArrayValue)obj;
                return this.equals(av.getMetaType());
            }
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                thisClass = Class.forName(this.getClassName(), false, loader);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (!thisClass.isAssignableFrom(clazz)) {
                return false;
            }
            return this.recursiveCheck((Object[])obj, this.dimension);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ArrayMetaType)) {
            return false;
        }
        ArrayMetaType other = (ArrayMetaType)obj;
        return this.getDimension() == other.getDimension() && this.getElementType().equals(other.getElementType());
    }

    public int hashCode() {
        if (this.cachedHashCode != Integer.MIN_VALUE) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getDimension() + this.getElementType().hashCode();
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuilder buffer = new StringBuilder(ArrayMetaType.class.getSimpleName());
        buffer.append("{type=");
        buffer.append(this.getTypeName());
        buffer.append(" dims=");
        buffer.append(this.dimension);
        buffer.append(" elementType=");
        buffer.append(this.elementType);
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }

    private boolean recursiveCheck(Object[] elements, int dimension) {
        if (dimension == 1) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null || this.elementType.isValue(elements[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                if (this.recursiveCheck((Object[])elements[i], dimension - 1)) continue;
                return false;
            }
        }
        return true;
    }
}

