/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.provider;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import org.jboss.dna.common.jdbc.JdbcMetadataI18n;
import org.jboss.dna.common.jdbc.provider.DatabaseMetadataProvider;
import org.jboss.dna.common.util.Logger;

public abstract class DefaultDatabaseMetadataProvider
implements DatabaseMetadataProvider {
    private static final long serialVersionUID = -4164910060171439260L;
    private String name;
    private Properties properties;
    private String emptyStringNotation;
    private String nullStringNotation;
    protected Logger log = Logger.getLogger(this.getClass());
    protected DatabaseMetaData databaseMetaData;
    protected Connection connection;

    public DefaultDatabaseMetadataProvider() {
    }

    public DefaultDatabaseMetadataProvider(String name) {
        this();
        this.setName(name);
    }

    protected abstract Connection openConnection() throws Exception;

    public void release(boolean silently) {
        block4: {
            if (this.databaseMetaData != null) {
                this.databaseMetaData = null;
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.log.debug(JdbcMetadataI18n.databaseConnectionHasBeenReleased.text(new Object[]{this.getName()}), new Object[0]);
                }
                catch (Exception ex) {
                    this.log.error(JdbcMetadataI18n.errorClosingDatabaseConnection, new Object[]{ex});
                    if (silently) break block4;
                    throw new RuntimeException(JdbcMetadataI18n.errorClosingDatabaseConnection.text(new Object[]{this.getName()}), ex);
                }
            }
        }
    }

    public DatabaseMetaData getDatabaseMetaData() throws Exception {
        if (this.databaseMetaData == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Getting Database metadata for a provider %1$s", this.getName()), new Object[0]);
            }
            this.databaseMetaData = this.getConnection().getMetaData();
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Database metadata received for a provider %1$s", this.getName()), new Object[0]);
            }
        }
        return this.databaseMetaData;
    }

    public Connection getConnection() throws Exception {
        if (this.connection == null) {
            this.connection = this.openConnection();
            this.log.info(JdbcMetadataI18n.databaseConnectionHasBeenEstablished, new Object[]{this.getName()});
        }
        return this.connection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmptyStringNotation() {
        return this.emptyStringNotation;
    }

    public void setEmptyStringNotation(String emptyStringNotation) {
        this.emptyStringNotation = emptyStringNotation;
    }

    public String getNullStringNotation() {
        return this.nullStringNotation;
    }

    public void setNullStringNotation(String nullStringNotation) {
        this.nullStringNotation = nullStringNotation;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

