/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.provider;

import java.sql.Connection;
import java.sql.DriverManager;
import org.jboss.dna.common.jdbc.provider.DefaultDatabaseMetadataProvider;
import org.jboss.dna.common.jdbc.provider.DriverDatabaseMetadataProvider;

public class DefaultDriverDatabaseMetadataProvider
extends DefaultDatabaseMetadataProvider
implements DriverDatabaseMetadataProvider {
    private static final long serialVersionUID = -3616979905696406464L;
    private String driverClassName;
    private String databaseUrl;
    private String userName;
    private String password;

    public DefaultDriverDatabaseMetadataProvider() {
    }

    public DefaultDriverDatabaseMetadataProvider(String name) {
        super(name);
    }

    protected Connection openConnection() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading JDBC driver class: " + this.getDriverClassName(), new Object[0]);
        }
        Class.forName(this.getDriverClassName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Opening database connection by using driver manager. The URL: " + this.getDatabaseUrl() + ". The user: " + this.getUserName(), new Object[0]);
        }
        return DriverManager.getConnection(this.getDatabaseUrl(), this.getUserName(), this.getPassword());
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

