/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.api.BestRowIdentifier;
import org.jboss.dna.common.jdbc.model.api.BestRowIdentifierScopeType;
import org.jboss.dna.common.jdbc.model.api.Column;
import org.jboss.dna.common.jdbc.model.api.TableColumn;
import org.jboss.dna.common.jdbc.model.spi.BestRowIdentifierBean;

public class BestRowIdentifierBeanTest
extends TestCase {
    BestRowIdentifier bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new BestRowIdentifierBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testSetScopeType() {
        this.bean.setScopeType(BestRowIdentifierScopeType.SESSION);
        BestRowIdentifierBeanTest.assertSame((String)"Unable to set scope type", (Object)BestRowIdentifierScopeType.SESSION, (Object)this.bean.getScopeType());
    }

    public void testGetColumns() {
        Set columnSet = this.bean.getColumns();
        BestRowIdentifierBeanTest.assertNotNull((String)"Unable to get columns", (Object)columnSet);
        BestRowIdentifierBeanTest.assertTrue((String)"Column set should be empty by default", (boolean)columnSet.isEmpty());
    }

    public void testAddColumn() {
        String COLUMN_NAME = "My column";
        TableColumn column = new DefaultModelFactory().createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn((Column)column);
        BestRowIdentifierBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testDeleteColumn() {
        String COLUMN_NAME = "My column";
        TableColumn column = new DefaultModelFactory().createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn((Column)column);
        BestRowIdentifierBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
        this.bean.deleteColumn((Column)column);
        BestRowIdentifierBeanTest.assertTrue((String)"Column set should be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testFindColumnByName() {
        String COLUMN_NAME = "My column";
        TableColumn column = new DefaultModelFactory().createTableColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn((Column)column);
        BestRowIdentifierBeanTest.assertSame((String)"Unable to find column", (Object)column, (Object)this.bean.findColumnByName(COLUMN_NAME));
    }
}

