/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.api.Column;
import org.jboss.dna.common.jdbc.model.api.NullabilityType;
import org.jboss.dna.common.jdbc.model.api.Privilege;
import org.jboss.dna.common.jdbc.model.api.SchemaObject;
import org.jboss.dna.common.jdbc.model.api.SqlType;
import org.jboss.dna.common.jdbc.model.api.Table;
import org.jboss.dna.common.jdbc.model.spi.ColumnBean;

public class ColumnBeanTest
extends TestCase {
    private Column bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new ColumnBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testSetOwner() {
        Table table = new DefaultModelFactory().createTable();
        this.bean.setOwner((SchemaObject)table);
        ColumnBeanTest.assertSame((String)"Unable to set owner", (Object)table, (Object)this.bean.getOwner());
    }

    public void testSetNullabilityType() {
        this.bean.setNullabilityType(NullabilityType.NULLABLE);
        ColumnBeanTest.assertSame((String)"Unable to set nullability type", (Object)NullabilityType.NULLABLE, (Object)this.bean.getNullabilityType());
    }

    public void testSetSqlType() {
        this.bean.setSqlType(SqlType.VARCHAR);
        ColumnBeanTest.assertSame((String)"Unable to set SQL type", (Object)SqlType.VARCHAR, (Object)this.bean.getSqlType());
    }

    public void testSetTypeName() {
        String TYPE_NAME = "My Type";
        this.bean.setTypeName(TYPE_NAME);
        ColumnBeanTest.assertEquals((String)"Unable to set type name", (String)TYPE_NAME, (String)this.bean.getTypeName());
    }

    public void testSetSize() {
        Integer size = new Integer(255);
        this.bean.setSize(size);
        ColumnBeanTest.assertSame((String)"Unable to set size", (Object)size, (Object)this.bean.getSize());
    }

    public void testSetPrecision() {
        Integer precision = new Integer(5);
        this.bean.setPrecision(precision);
        ColumnBeanTest.assertSame((String)"Unable to set precision", (Object)precision, (Object)this.bean.getPrecision());
    }

    public void testSetRadix() {
        Integer radix = new Integer(2);
        this.bean.setRadix(radix);
        ColumnBeanTest.assertSame((String)"Unable to set radix", (Object)radix, (Object)this.bean.getRadix());
    }

    public void testSetDefaultValue() {
        String defaultValue = "Hello";
        this.bean.setDefaultValue(defaultValue);
        ColumnBeanTest.assertEquals((String)"Unable to set default value", (String)defaultValue, (String)this.bean.getDefaultValue());
    }

    public void testSetOrdinalPosition() {
        Integer ordinalPosition = new Integer(1);
        this.bean.setOrdinalPosition(ordinalPosition);
        ColumnBeanTest.assertSame((String)"Unable to set ordinalPosition", (Object)ordinalPosition, (Object)this.bean.getOrdinalPosition());
    }

    public void testSetCharOctetLength() {
        Integer charOctetLength = new Integer(2);
        this.bean.setCharOctetLength(charOctetLength);
        ColumnBeanTest.assertSame((String)"Unable to set char octet length", (Object)charOctetLength, (Object)this.bean.getCharOctetLength());
    }

    public void testGetPrivileges() {
        Set privilegeSet = this.bean.getPrivileges();
        ColumnBeanTest.assertNotNull((String)"Unable to get privileges", (Object)privilegeSet);
        ColumnBeanTest.assertTrue((String)"Privilege set should be empty by default", (boolean)privilegeSet.isEmpty());
    }

    public void testAddPrivilege() {
        String PRIVILEGE_NAME = "SELECT";
        Privilege privilege = new DefaultModelFactory().createPrivilege();
        privilege.setName(PRIVILEGE_NAME);
        this.bean.addPrivilege(privilege);
        ColumnBeanTest.assertFalse((String)"Privilege set should not be empty", (boolean)this.bean.getPrivileges().isEmpty());
    }

    public void testDeletePrivilege() {
        String PRIVILEGE_NAME = "SELECT";
        Privilege privilege = new DefaultModelFactory().createPrivilege();
        privilege.setName(PRIVILEGE_NAME);
        this.bean.addPrivilege(privilege);
        ColumnBeanTest.assertFalse((String)"Privilege set should not be empty", (boolean)this.bean.getPrivileges().isEmpty());
        this.bean.deletePrivilege(privilege);
        ColumnBeanTest.assertTrue((String)"Privilege set should not be empty", (boolean)this.bean.getPrivileges().isEmpty());
    }

    public void testFindPriviledgeByName() {
        String PRIVILEGE_NAME = "SELECT";
        Privilege privilege = new DefaultModelFactory().createPrivilege();
        privilege.setName(PRIVILEGE_NAME);
        this.bean.addPrivilege(privilege);
        ColumnBeanTest.assertSame((String)"Unable to find privilege", (Object)privilege, (Object)this.bean.findPriviledgeByName(PRIVILEGE_NAME));
    }
}

