/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.api.ForeignKey;
import org.jboss.dna.common.jdbc.model.api.ForeignKeyColumn;
import org.jboss.dna.common.jdbc.model.api.KeyDeferrabilityType;
import org.jboss.dna.common.jdbc.model.api.KeyModifyRuleType;
import org.jboss.dna.common.jdbc.model.api.PrimaryKey;
import org.jboss.dna.common.jdbc.model.api.Table;
import org.jboss.dna.common.jdbc.model.spi.ForeignKeyBean;

public class ForeignKeyBeanTest
extends TestCase {
    private ForeignKey bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new ForeignKeyBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testGetColumns() {
        Set columns = this.bean.getColumns();
        ForeignKeyBeanTest.assertNotNull((String)"Unable to get columns", (Object)columns);
        ForeignKeyBeanTest.assertTrue((String)"Column set should be empty by default", (boolean)columns.isEmpty());
    }

    public void testAddColumn() {
        String COLUMN_NAME = "My column";
        ForeignKeyColumn column = new DefaultModelFactory().createForeignKeyColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        ForeignKeyBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testDeleteColumn() {
        String COLUMN_NAME = "My column";
        ForeignKeyColumn column = new DefaultModelFactory().createForeignKeyColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        ForeignKeyBeanTest.assertFalse((String)"Column set should not be empty", (boolean)this.bean.getColumns().isEmpty());
        this.bean.deleteColumn(column);
        ForeignKeyBeanTest.assertTrue((String)"Column set should be empty", (boolean)this.bean.getColumns().isEmpty());
    }

    public void testFindColumnByName() {
        String COLUMN_NAME = "My column";
        ForeignKeyColumn column = new DefaultModelFactory().createForeignKeyColumn();
        column.setName(COLUMN_NAME);
        this.bean.addColumn(column);
        ForeignKeyBeanTest.assertSame((String)"Unable to find column", (Object)column, (Object)this.bean.findColumnByName(COLUMN_NAME));
    }

    public void testSetSourceTable() {
        Table sourceTable = new DefaultModelFactory().createTable();
        this.bean.setSourceTable(sourceTable);
        ForeignKeyBeanTest.assertSame((String)"Unable to set source table", (Object)sourceTable, (Object)this.bean.getSourceTable());
    }

    public void testSetSourcePrimaryKey() {
        PrimaryKey primaryKey = new DefaultModelFactory().createPrimaryKey();
        this.bean.setSourcePrimaryKey(primaryKey);
        ForeignKeyBeanTest.assertSame((String)"Unable to set source primary key", (Object)primaryKey, (Object)this.bean.getSourcePrimaryKey());
    }

    public void testSetUpdateRule() {
        this.bean.setUpdateRule(KeyModifyRuleType.CASCADE);
        ForeignKeyBeanTest.assertSame((String)"unable to set update rule", (Object)KeyModifyRuleType.CASCADE, (Object)this.bean.getUpdateRule());
    }

    public void testSetDeleteRule() {
        this.bean.setDeleteRule(KeyModifyRuleType.SET_NULL);
        ForeignKeyBeanTest.assertSame((String)"unable to set delete rule", (Object)KeyModifyRuleType.SET_NULL, (Object)this.bean.getDeleteRule());
    }

    public void testSetDeferrability() {
        this.bean.setDeferrability(KeyDeferrabilityType.INITIALLY_DEFERRED);
        ForeignKeyBeanTest.assertSame((String)"unable to set deferrability", (Object)KeyDeferrabilityType.INITIALLY_DEFERRED, (Object)this.bean.getDeferrability());
    }
}

